<?php
/**
 * @package Jollyany
 * @author TemPlaza http://www.templaza.com
 * @copyright Copyright (c) 2010 - 2022 Jollyany
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
/**
 * @package Extra Addons SP Page Builder
 * @author WarpTheme https://warptheme.com
 * @copyright Copyright (c) 2015 - 2018 WarpTheme
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');
use Jollyany\Helper\PageBuilder;
use Joomla\CMS\Language\Text;
if (file_exists(JPATH_LIBRARIES . DIRECTORY_SEPARATOR . 'jollyany'. DIRECTORY_SEPARATOR . 'framework' . DIRECTORY_SEPARATOR . 'library' . DIRECTORY_SEPARATOR .'jollyany' . DIRECTORY_SEPARATOR . 'Helper' . DIRECTORY_SEPARATOR. 'PageBuilder.php')) {
    SpAddonsConfig::addonConfig(
        array(
            'type' => 'content',
            'addon_name' => 'ukpricing',
            'title' => JText::_('UK Pricing'),
            'desc' => JText::_('Price box allows you to display not just the cost, but also the features you wish to portray.'),
            'icon' => JURI::root() . 'plugins/sppagebuilder/jollyany/addons/ukpricing/assets/images/icon.png',
            'category' => 'Jollyany',
            'attr' => array(
                'general' => array(
                    'admin_label' => array(
                        'type' => 'text',
                        'title' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
                        'std' => '',
                    ),

                    'price_title' => array(
                        'type' => 'text',
                        'title' => JText::_('Title'),
                        'std' => 'Small Business',
                    ),
                    'price_meta' => array(
                        'type' => 'text',
                        'title' => JText::_('Meta'),
                        'std' => 'billed weekly',
                    ),
                    'price_description' => array(
                        'type' => 'text',
                        'title' => JText::_('Description'),
                        'std' => 'This plan is suitable for small businesses and offices.',
                    ),
                    'price' => array(
                        'type' => 'text',
                        'title' => JText::_('Price'),
                        'desc' => JText::_('Define the price for price box'),
                        'std' => '69',
                    ),
                    'symbol' => array(
                        'type' => 'text',
                        'title' => JText::_('Price symbol'),
                        'placeholder' => '$',
                        'std' => '$',
                    ),
                    'label_text' => array(
                        'type' => 'text',
                        'title' => JText::_('Highlight'),
                        'desc' => JText::_('Indicate important notes and highlight parts of your content.'),
                        'placeholder' => 'Popular',
                        'std' => '',
                    ),
                    'label_styles' => array(
                        'type' => 'select',
                        'title' => JText::_('Highlight Style'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uk-label-success' => JText::_('Success'),
                            'uk-label-warning' => JText::_('Warning'),
                            'uk-label-danger' => JText::_('Danger'),
                            'uk-label-custom' => JText::_('Custom'),
                        ),
                        'depends' => array(array('label_text', '!=', '')),
                    ),
                    'label_background_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Background Color'),
                        'depends' => array(
                            array('label_text', '!=', ''),
                            array('label_styles', '=', 'uk-label-custom')
                        ),
                    ),
                    'label_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.uk-label-custom { font-family: {{ VALUE }}; }',
                        ),
                        'depends' => array(
                            array('label_text', '!=', ''),
                            array('label_styles', '=', 'uk-label-custom')
                        ),
                    ),
                    'label_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Label Color'),
                        'depends' => array(
                            array('label_text', '!=', ''),
                            array('label_styles', '=', 'uk-label-custom')
                        ),
                    ),
                    // Repeatable Item
                    'uk_pricing_items' => array(
                        'title' => JText::_('Items'),
                        'attr' => array(
                            'title' => array(
                                'type' => 'text',
                                'title' => JText::_('Item'),
                                'std' => '',
                            ),
                            'title_link' => array(
                                'type' => 'media',
                                'format' => 'attachment',
                                'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
                                'placeholder' => 'http://www.example.com',
                                'std' => '',
                                'hide_preview' => true,
                            ),
                            'link_new_tab' => array(
                                'type' => 'select',
                                'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
                                'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
                                'values' => array(
                                    '' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
                                    '_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
                                ),
                                'depends' => array(array('title_link', '!=', '')),
                            ),
                            'icon_type' => array(
                                'type' => 'select',
                                'title' => JText::_('Icon Type'),
                                'desc' => JText::_('Select icon type from the list'),
                                'values' => array(
                                    '' => JText::_('None'),
                                    'fontawesome_icon' => JText::_('FontAwesome'),
                                    'uikit_icon' => JText::_('Uikit'),
                                ),
                                'std' => 'fontawesome_icon',
                            ),
                            'icon_name' => array(
                                'type' => 'icon',
                                'title' => JText::_('Icon'),
                                'std' => 'fa-check',
                                'depends' => array(
                                    array('icon_type', '=', 'fontawesome_icon'),
                                ),
                            ),
                            'uikit' => array( // New Uikit Icon
                                'type' => 'select',
                                'title' => JText::_('Uikit Icon'),
                                'desc' => JText::_('Select an SVG icon from the list. Learn more <a href="https://getuikit.com/docs/icon#library" target="_blank">https://getuikit.com/docs/icon</a>'),
                                'values' => array(
                                    '' => JText::_('Select an optional icon.'),
                                    'home' => 'Home',
                                    'sign-in' => 'Sign-in',
                                    'sign-out' => 'Sign-out',
                                    'user' => 'User',
                                    'users' => 'Users',
                                    'lock' => 'Lock',
                                    'unlock' => 'Unlock',
                                    'settings' => 'Settings',
                                    'cog' => 'Cog',
                                    'nut' => 'Nut',
                                    'comment' => 'Comment',
                                    'commenting' => 'Commenting',
                                    'comments' => 'Comments',
                                    'hashtag' => 'Hashtag',
                                    'tag' => 'Tag',
                                    'cart' => 'Cart',
                                    'credit-card' => 'Credit-card',
                                    'mail' => 'Mail',
                                    'receiver' => 'Receiver',
                                    'search' => 'Search',
                                    'location' => 'Location',
                                    'bookmark' => 'Bookmark',
                                    'code' => 'Code',
                                    'paint-bucket' => 'Paint-bucket',
                                    'camera' => 'Camera',
                                    'bell' => 'Bell',
                                    'bolt' => 'Bolt',
                                    'star' => 'Star',
                                    'heart' => 'Heart',
                                    'happy' => 'Happy',
                                    'lifesaver' => 'Lifesaver',
                                    'rss' => 'Rss',
                                    'social' => 'Social',
                                    'git-branch' => 'Git-branch',
                                    'git-fork' => 'Git-fork',
                                    'world' => 'World',
                                    'calendar' => 'Calendar',
                                    'clock' => 'Clock',
                                    'history' => 'History',
                                    'future' => 'Future',
                                    'pencil' => 'Pencil',
                                    'trash' => 'Trash',
                                    'move' => 'Move',
                                    'link' => 'Link',
                                    'question' => 'Question',
                                    'info' => 'Info',
                                    'warning' => 'Warning',
                                    'image' => 'Image',
                                    'thumbnails' => 'Thumbnails',
                                    'table' => 'Table',
                                    'list' => 'List',
                                    'menu' => 'Menu',
                                    'grid' => 'Grid',
                                    'more' => 'More',
                                    'more-vertical' => 'More-vertical',
                                    'plus' => 'Plus',
                                    'plus-circle' => 'Plus-circle',
                                    'minus' => 'Minus',
                                    'minus-circle' => 'Minus-circle',
                                    'close' => 'Close',
                                    'check' => 'Check',
                                    'ban' => 'Ban',
                                    'refresh' => 'Refresh',
                                    'play' => 'Play',
                                    'play-circle' => 'Play-circle',
                                    'tv' => 'Tv',
                                    'desktop' => 'Desktop',
                                    'laptop' => 'Laptop',
                                    'tablet' => 'Tablet',
                                    'phone' => 'Phone',
                                    'tablet-landscape' => 'Tablet-landscape',
                                    'phone-landscape' => 'Phone-landscape',
                                    'file' => 'File',
                                    'copy' => 'Copy',
                                    'file-edit' => 'File-edit',
                                    'folder' => 'Folder',
                                    'album' => 'Album',
                                    'push' => 'Push',
                                    'pull' => 'Pull',
                                    'server' => 'Server',
                                    'database' => 'Database',
                                    'cloud-upload' => 'Cloud-upload',
                                    'cloud-download' => 'Cloud-download',
                                    'download' => 'Download',
                                    'upload' => 'Upload',
                                    'reply' => 'Reply',
                                    'forward' => 'Forward',
                                    'expand' => 'Expand',
                                    'shrink' => 'Shrink',
                                    'arrow-up' => 'Arrow-up',
                                    'arrow-down' => 'Arrow-down',
                                    'arrow-left' => 'Arrow-left',
                                    'arrow-right' => 'Arrow-right',
                                    'chevron-up' => 'Chevron-up',
                                    'chevron-down' => 'Chevron-down',
                                    'chevron-left' => 'Chevron-left',
                                    'chevron-right' => 'Chevron-right',
                                    'triangle-up' => 'Triangle-up',
                                    'triangle-down' => 'Triangle-down',
                                    'triangle-left' => 'Triangle-left',
                                    'triangle-right' => 'Triangle-right',
                                    'bold' => 'Bold',
                                    'italic' => 'Italic',
                                    'strikethrough' => 'Strikethrough',
                                    'video-camera' => 'Video-camera',
                                    'quote-right' => 'Quote-right',
                                    '500px' => '500px',
                                    'behance' => 'Behance',
                                    'dribbble' => 'Dribbble',
                                    'facebook' => 'Facebook',
                                    'flickr' => 'Flickr',
                                    'foursquare' => 'Foursquare',
                                    'github' => 'Github',
                                    'github-alt' => 'Github-alt',
                                    'gitter' => 'Gitter',
                                    'google' => 'Google',
                                    'google-plus' => 'Google-plus',
                                    'instagram' => 'Instagram',
                                    'joomla' => 'Joomla',
                                    'linkedin' => 'Linkedin',
                                    'pagekit' => 'Pagekit',
                                    'pinterest' => 'Pinterest',
                                    'soundcloud' => 'Soundcloud',
                                    'tripadvisor' => 'Tripadvisor',
                                    'tumblr' => 'Tumblr',
                                    'twitter' => 'Twitter',
                                    'uikit' => 'Uikit',
                                    'etsy' => 'Etsy',
                                    'vimeo' => 'Vimeo',
                                    'whatsapp' => 'Whatsapp',
                                    'wordpress' => 'Wordpress',
                                    'xing' => 'Xing',
                                    'yelp' => 'Yelp',
                                    'youtube' => 'Youtube',
                                    'print' => 'Print',
                                    'reddit' => 'Reddit',
                                    'file-text' => 'File Text',
                                    'file-pdf' => 'File Pdf',
                                    'chevron-double-left' => 'Chevron Double Left',
                                    'chevron-double-right' => 'Chevron Double Right',
                                ),
                                'std' => 'check',
                                'depends' => array(
                                    array('icon_type', '=', 'uikit_icon'),
                                ),
                            ),
                            'icon_color' => array(
                                'type' => 'color',
                                'title' => JText::_('Icon color'),
                                'depends' => array(array('icon_type', '!=', '')),
                            ),
                        ),
                    ),
                    'button_link' => array(
                        'type' => 'media',
                        'format' => 'attachment',
                        'title' => JText::_('Link'),
                        'placeholder' => 'http://www.example.com',
                        'hide_preview' => true,
                    ),
                    'button_title' => array(
                        'type' => 'text',
                        'title' => JText::_('Link Text'),
                        'std' => 'Learn More',
                        'depends' => array(array('button_link', '!=', '')),
                    ),
                    'separator_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Body'),
                    ),
                    'body_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.uk-list li { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'card_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select one of the boxed card styles or a blank panel.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'default' => JText::_('Card Default'),
                            'primary' => JText::_('Card Primary'),
                            'secondary' => JText::_('Card Secondary'),
                            'muted' => JText::_('Card Muted'),
                            'hover' => JText::_('Card Hover'),
                            'custom' => JText::_('Custom'),
                        ),
                        'std' => '',
                    ),
                    'panel_link' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Link Card'),
                        'desc' => JText::_('Link the whole card if a link exists.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'card_background' => array(
                        'type' => 'color',
                        'title' => JText::_('Background Color'),
                        'std' => '#1e87f0',
                        'depends' => array(array('card_style', '=', 'custom')),
                    ),
                    'card_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Color'),
                        'depends' => array(array('card_style', '=', 'custom')),
                    ),
                    'card_border' => array(
                        'type' => 'slider',
                        'title' => JText::_('Border Width'),
                        'min' => 0,
                        'max' => 100,
                        'depends' => array(
                            array('card_style', '=', 'custom')
                        ),
                    ),
                    'card_border_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Border Color'),
                        'depends' => array(array('card_style', '=', 'custom')),
                    ),
                    'card_border_radius' => array(
                        'type' => 'select',
                        'title' => JText::_('Border Radius'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'rounded' => JText::_('Rounded'),
                            'circle' => JText::_('Circle'),
                            'pill' => JText::_('Pill'),
                        ),
                        'std' => '',
                    ),
                    'card_size' => array(
                        'type' => 'select',
                        'title' => JText::_('Padding'),
                        'desc' => JText::_('Define the card\'s size by selecting the padding between the card and its content.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'large' => JText::_('Large'),
                            'custom' => JText::_('Custom'),
                        ),
                        'std' => '',
                        'depends' => array(array('card_style', '!=', '')),
                    ),
                    'card_content_padding' => array(
                        'type' => 'select',
                        'title' => JText::_('Padding'),
                        'desc' => JText::_('Add padding to the content if the image is top, bottom, left or right aligned.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'small' => JText::_('Small'),
                            'default' => JText::_('Default'),
                            'large' => JText::_('Large'),
                        ),
                        'std' => '',
                        'depends' => array(array('card_style', '=', '')),
                    ),

                    'body_padding_top' => array(
                        'type' => 'slider',
                        'title' => JText::_('Padding Top'),
                        'std' => '25',
                        'min' => 0,
                        'max' => 100,
                        'depends' => array(
                            array('card_size', '=', 'custom')
                        ),
                    ),
                    'body_padding_bottom' => array(
                        'type' => 'slider',
                        'title' => JText::_('Padding Bottom'),
                        'std' => '25',
                        'min' => 0,
                        'max' => 100,
                        'depends' => array(
                            array('card_size', '=', 'custom')
                        ),
                    ),
                    'body_padding_left' => array(
                        'type' => 'slider',
                        'title' => JText::_('Padding Left'),
                        'std' => '25',
                        'min' => 0,
                        'max' => 100,
                        'depends' => array(
                            array('card_size', '=', 'custom')
                        ),
                    ),
                    'body_padding_right' => array(
                        'type' => 'slider',
                        'title' => JText::_('Padding Right'),
                        'std' => '25',
                        'min' => 0,
                        'max' => 100,
                        'depends' => array(
                            array('card_size', '=', 'custom')
                        ),
                    ),
                    'hover' => array(
                        'type' => 'select',
                        'title' => JText::_('Hover Box Shadow'),
                        'desc' => JText::_('To apply a box shadow on hover, add one of the following classes.'),
                        'values' => array(
                            '' => JText::_('No'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('Xlarge'),
                        ),
                        'std' => '',
                    ),

                    'separator_list_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('List Items'),
                    ),
                    'title_text_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Use one of these classes to apply a different color to text elements.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                    ),
                    'custom_title_text_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Color'),
                        'depends' => array(
                            array('title_text_color', '=', '')
                        ),
                    ),
                    'list_marker' => array(
                        'type' => 'select',
                        'title' => JText::_('Marker'),
                        'desc' => JText::_('Select the marker of the list items.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'disc' => JText::_('Disc'),
                            'circle' => JText::_('Circle'),
                            'square' => JText::_('Square'),
                            'decimal' => JText::_('Decimal'),
                            'hyphen' => JText::_('Hyphen'),
                            'bullet' => JText::_('Image Bullet'),
                        ),
                        'std' => '',
                    ),

                    'list_marker_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Marker Color'),
                        'desc' => JText::_('Select the color of the list markers.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                        ),
                        'std' => '',
                    ),

                    'list_styles' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select the list style.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'divider' => JText::_('Divider'),
                            'striped' => JText::_('Striped'),
                        ),
                        'std' => '',
                    ),
                    'separator_title_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Title'),
                        'depends' => array(array('price_title', '!=', '')),
                    ),
                    'divider_type' => array(
                        'type' => 'select',
                        'title' => JText::_('Divider'),
                        'desc' => JText::_('Create dividers to separate content and apply different styles to them.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'icon' => JText::_('Icon'),
                            'small' => JText::_('Small'),
                        ),
                        'std' => '',
                    ),
                    'heading_selector' => array(
                        'type' => 'select',
                        'title' => JText::_('HTML Element'),
                        'desc' => JText::_('Choose one of the seven heading elements to fit your semantic structure.'),
                        'values' => array(
                            'h1' => JText::_('h1'),
                            'h2' => JText::_('h2'),
                            'h3' => JText::_('h3'),
                            'h4' => JText::_('h4'),
                            'h5' => JText::_('h5'),
                            'h6' => JText::_('h6'),
                            'div' => JText::_('div'),
                        ),
                        'std' => 'h3',
                    ),
                    'title_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.ui-title { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'title_font_weight' => array(
                        'type' => 'select',
                        'title' => JText::_('Font weight'),
                        'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'light' => JText::_('Light'),
                            'normal' => JText::_('Normal'),
                            'bold' => JText::_('Bold'),
                            'lighter' => JText::_('Lighter'),
                            'bolder' => JText::_('Bolder'),
                        ),
                    ),
                    'heading_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
                        'values' => array(
                            '' => JText::_('None'),
                            'heading-2xlarge' => JText::_('2XLarge'),
                            'heading-xlarge' => JText::_('XLarge'),
                            'heading-large' => JText::_('Large'),
                            'heading-medium' => JText::_('Medium'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => '',
                    ),
                    'title_decoration' => array(
                        'type' => 'select',
                        'title' => JText::_('Decoration'),
                        'desc' => JText::_('Decorate the title with a divider, bullet or a line that is vertically centered to the title'),
                        'values' => array(
                            '' => JText::_('None'),
                            'uk-heading-divider' => JText::_('Divider'),
                            'uk-heading-bullet' => JText::_('Bullet'),
                            'uk-heading-line' => JText::_('Line'),
                        ),
                        'std' => '',
                    ),
                    'title_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined title text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                    ),
                    'custom_title_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('title_color', '=', '')
                        ),
                    ),
                    'title_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'title_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'title_alignment' => array(
                        'type' => 'select',
                        'title' => JText::_('Alignment'),
                        'desc' => JText::_('Align the title text above or below the pricing.'),
                        'values' => array(
                            'top' => JText::_('Top'),
                            '' => JText::_('Bottom'),
                        ),
                        'std' => '',
                    ),
                    'separator_meta_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Meta'),
                    ),
                    'meta_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.plan-period { font-family: {{ VALUE }}; }',
                        ),
                    ),
                    'meta_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
                        'values' => array(
                            '' => JText::_('None'),
                            'text-meta' => JText::_('Meta'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => '',
                        'depends' => array(array('price_description', '!=', '')),
                    ),
                    'meta_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined meta text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                    ),
                    'custom_meta_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('meta_color', '=', ''),
                        ),
                    ),
                    'meta_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'meta_alignment' => array(
                        'type' => 'select',
                        'title' => JText::_('Alignment'),
                        'desc' => JText::_('Align the meta text above or below the title.'),
                        'values' => array(
                            'top' => JText::_('Above Price'),
                            '' => JText::_('Below Price'),
                            'inline' => JText::_('Inline'),
                        ),
                        'std' => '',
                    ),
                    'meta_element' => array(
                        'type' => 'select',
                        'title' => JText::_('HTML Element'),
                        'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
                        'values' => array(
                            'h1' => JText::_('h1'),
                            'h2' => JText::_('h2'),
                            'h3' => JText::_('h3'),
                            'h4' => JText::_('h4'),
                            'h5' => JText::_('h5'),
                            'h6' => JText::_('h6'),
                            'div' => JText::_('div'),
                        ),
                        'std' => 'div',
                    ),
                    'meta_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                        'depends' => array(array('price_description', '!=', '')),
                    ),
                    'separator_description_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Description'),
                    ),
                    'description_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.plan-description { font-family: {{ VALUE }}; }',
                        ),
                    ),
                    'description_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
                        'values' => array(
                            '' => JText::_('None'),
                            'text-meta' => JText::_('Meta'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => '',
                        'depends' => array(array('price_description', '!=', '')),
                    ),
                    'description_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined description text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                        'depends' => array(array('price_description', '!=', '')),
                    ),
                    'custom_description_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('description_color', '=', ''),
                        ),
                    ),
                    'description_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'description_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                        'depends' => array(array('price_description', '!=', '')),
                    ),
                    'separator_price_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Price'),
                    ),
                    'price_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.pricing-amount { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'price_heading' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
                        'values' => array(
                            '' => JText::_('None'),
                            'heading-2xlarge' => JText::_('2XLarge'),
                            'heading-xlarge' => JText::_('XLarge'),
                            'heading-large' => JText::_('Large'),
                            'heading-medium' => JText::_('Medium'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => 'heading-medium',
                        'depends' => array(array('price', '!=', '')),
                    ),
                    'price_fontsize' => array(
                        'type' => 'slider',
                        'title' => JText::_('Font Size'),
                        'std' => '70',
                        'max' => 200,
                        'depends' => array(
                            array('price_heading', '=', '')
                        ),
                    ),
                    'price_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined price color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                    ),
                    'custom_price_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('price_color', '=', '')
                        ),
                    ),
                    'price_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'separator_price_symbol_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Symbol'),
                    ),
                    'price_symbol_heading' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
                        'values' => array(
                            '' => JText::_('None'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => '',
                    ),
                    'price_symbol_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.pricing-symbol { font-family: {{ VALUE }}; }',
                        ),
                    ),
                    'symbol_font_weight' => array(
                        'type' => 'select',
                        'title' => JText::_('Font weight'),
                        'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'light' => JText::_('Light'),
                            'normal' => JText::_('Normal'),
                            'bold' => JText::_('Bold'),
                            'lighter' => JText::_('Lighter'),
                            'bolder' => JText::_('Bolder'),
                        ),
                        'std' => 'normal',
                    ),
                    'currency_fontsize' => array(
                        'type' => 'slider',
                        'title' => JText::_('Font Size'),
                        'std' => '25',
                        'max' => 100,
                    ),
                    'currency_margin' => array(
                        'type' => 'slider',
                        'title' => JText::_('Margin Top'),
                        'std' => '15',
                        'max' => 100,
                    ),
                    'symbol_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the title text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                        'depends' => array(array('price', '!=', '')),
                    ),
                    'custom_currency_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Currency Color'),
                        'depends' => array(
                            array('symbol_color', '=', '')
                        ),
                    ),
                    'separator_price_feature_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Features'),
                    ),
                    'feature_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'separator_icon_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Icon'),
                    ),
                    'all_icon_type' => array(
                        'type' => 'select',
                        'title' => JText::_('Icon Type'),
                        'desc' => JText::_('Select icon type from the list'),
                        'values' => array(
                            '' => JText::_('None'),
                            'fontawesome_icon' => JText::_('FontAwesome'),
                            'uikit_icon' => JText::_('Uikit'),
                        ),
                        'std' => 'fontawesome_icon',
                    ),
                    'all_icon_name' => array(
                        'type' => 'icon',
                        'title' => JText::_('Icon'),
                        'std' => '',
                        'depends' => array(
                            array('all_icon_type', '=', 'fontawesome_icon'),
                        ),
                    ),
                    'all_uikit' => array( // New Uikit Icon
                        'type' => 'select',
                        'title' => JText::_('Uikit Icon'),
                        'desc' => JText::_('Select an SVG icon from the list. Learn more <a href="https://getuikit.com/docs/icon#library" target="_blank">https://getuikit.com/docs/icon</a>'),
                        'values' => array(
                            '' => JText::_('Select an optional icon.'),
                            'home' => 'Home',
                            'sign-in' => 'Sign-in',
                            'sign-out' => 'Sign-out',
                            'user' => 'User',
                            'users' => 'Users',
                            'lock' => 'Lock',
                            'unlock' => 'Unlock',
                            'settings' => 'Settings',
                            'cog' => 'Cog',
                            'nut' => 'Nut',
                            'comment' => 'Comment',
                            'commenting' => 'Commenting',
                            'comments' => 'Comments',
                            'hashtag' => 'Hashtag',
                            'tag' => 'Tag',
                            'cart' => 'Cart',
                            'credit-card' => 'Credit-card',
                            'mail' => 'Mail',
                            'receiver' => 'Receiver',
                            'search' => 'Search',
                            'location' => 'Location',
                            'bookmark' => 'Bookmark',
                            'code' => 'Code',
                            'paint-bucket' => 'Paint-bucket',
                            'camera' => 'Camera',
                            'bell' => 'Bell',
                            'bolt' => 'Bolt',
                            'star' => 'Star',
                            'heart' => 'Heart',
                            'happy' => 'Happy',
                            'lifesaver' => 'Lifesaver',
                            'rss' => 'Rss',
                            'social' => 'Social',
                            'git-branch' => 'Git-branch',
                            'git-fork' => 'Git-fork',
                            'world' => 'World',
                            'calendar' => 'Calendar',
                            'clock' => 'Clock',
                            'history' => 'History',
                            'future' => 'Future',
                            'pencil' => 'Pencil',
                            'trash' => 'Trash',
                            'move' => 'Move',
                            'link' => 'Link',
                            'question' => 'Question',
                            'info' => 'Info',
                            'warning' => 'Warning',
                            'image' => 'Image',
                            'thumbnails' => 'Thumbnails',
                            'table' => 'Table',
                            'list' => 'List',
                            'menu' => 'Menu',
                            'grid' => 'Grid',
                            'more' => 'More',
                            'more-vertical' => 'More-vertical',
                            'plus' => 'Plus',
                            'plus-circle' => 'Plus-circle',
                            'minus' => 'Minus',
                            'minus-circle' => 'Minus-circle',
                            'close' => 'Close',
                            'check' => 'Check',
                            'ban' => 'Ban',
                            'refresh' => 'Refresh',
                            'play' => 'Play',
                            'play-circle' => 'Play-circle',
                            'tv' => 'Tv',
                            'desktop' => 'Desktop',
                            'laptop' => 'Laptop',
                            'tablet' => 'Tablet',
                            'phone' => 'Phone',
                            'tablet-landscape' => 'Tablet-landscape',
                            'phone-landscape' => 'Phone-landscape',
                            'file' => 'File',
                            'copy' => 'Copy',
                            'file-edit' => 'File-edit',
                            'folder' => 'Folder',
                            'album' => 'Album',
                            'push' => 'Push',
                            'pull' => 'Pull',
                            'server' => 'Server',
                            'database' => 'Database',
                            'cloud-upload' => 'Cloud-upload',
                            'cloud-download' => 'Cloud-download',
                            'download' => 'Download',
                            'upload' => 'Upload',
                            'reply' => 'Reply',
                            'forward' => 'Forward',
                            'expand' => 'Expand',
                            'shrink' => 'Shrink',
                            'arrow-up' => 'Arrow-up',
                            'arrow-down' => 'Arrow-down',
                            'arrow-left' => 'Arrow-left',
                            'arrow-right' => 'Arrow-right',
                            'chevron-up' => 'Chevron-up',
                            'chevron-down' => 'Chevron-down',
                            'chevron-left' => 'Chevron-left',
                            'chevron-right' => 'Chevron-right',
                            'triangle-up' => 'Triangle-up',
                            'triangle-down' => 'Triangle-down',
                            'triangle-left' => 'Triangle-left',
                            'triangle-right' => 'Triangle-right',
                            'bold' => 'Bold',
                            'italic' => 'Italic',
                            'strikethrough' => 'Strikethrough',
                            'video-camera' => 'Video-camera',
                            'quote-right' => 'Quote-right',
                            '500px' => '500px',
                            'behance' => 'Behance',
                            'dribbble' => 'Dribbble',
                            'facebook' => 'Facebook',
                            'flickr' => 'Flickr',
                            'foursquare' => 'Foursquare',
                            'github' => 'Github',
                            'github-alt' => 'Github-alt',
                            'gitter' => 'Gitter',
                            'google' => 'Google',
                            'instagram' => 'Instagram',
                            'joomla' => 'Joomla',
                            'linkedin' => 'Linkedin',
                            'pagekit' => 'Pagekit',
                            'pinterest' => 'Pinterest',
                            'soundcloud' => 'Soundcloud',
                            'tripadvisor' => 'Tripadvisor',
                            'tumblr' => 'Tumblr',
                            'twitter' => 'Twitter',
                            'uikit' => 'Uikit',
                            'etsy' => 'Etsy',
                            'vimeo' => 'Vimeo',
                            'whatsapp' => 'Whatsapp',
                            'wordpress' => 'Wordpress',
                            'xing' => 'Xing',
                            'yelp' => 'Yelp',
                            'youtube' => 'Youtube',
                            'print' => 'Print',
                            'reddit' => 'Reddit',
                            'file-text' => 'File Text',
                            'file-pdf' => 'File Pdf',
                            'chevron-double-left' => 'Chevron Double Left',
                            'chevron-double-right' => 'Chevron Double Right',
                        ),
                        'std' => 'check',
                        'depends' => array(
                            array('all_icon_type', '=', 'uikit_icon'),
                        ),
                    ),
                    'all_icon_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Icon color'),
                        'depends' => array(array('all_icon_type', '!=', '')),
                    ),
                    'icon_size' => array(
                        'type' => 'slider',
                        'title' => JText::_('Icon Size'),
                        'placeholder' => 20,
                        'std' => '20',
                        'max' => 400,
                    ),
                    'separator_button_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Link'),
                    ),
                    'link_new_tab' => array(
                        'type' => 'select',
                        'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
                        'values' => array(
                            '' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
                            '_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
                        ),
                    ),
                    'button_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Set the button style.'),
                        'values' => array(
                            '' => JText::_('Button Default'),
                            'primary' => JText::_('Button Primary'),
                            'secondary' => JText::_('Button Secondary'),
                            'danger' => JText::_('Button Danger'),
                            'text' => JText::_('Button Text'),
                            'link' => JText::_('Link'),
                            'link-muted' => JText::_('Link Muted'),
                            'link-text' => JText::_('Link Text'),
                            'custom' => JText::_('Custom'),
                        ),
                        'std' => '',
                        'depends' => array(array('button_title', '!=', '')),
                    ),
                    'separator_button_custom_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Custom Button Style'),
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        )
                    ),
                    'button_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        ),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.uk-button-custom { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'button_background' => array(
                        'type' => 'color',
                        'title' => JText::_('Background Color'),
                        'std' => '#1e87f0',
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        )
                    ),
                    'button_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Button Color'),
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        )
                    ),
                    'button_background_hover' => array(
                        'type' => 'color',
                        'title' => JText::_('Hover Background Color'),
                        'std' => '#1e87f0',
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        )
                    ),
                    'button_hover_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Hover Button Color'),
                        'depends' => array(
                            array('button_style', '=', 'custom'),
                        )
                    ),
                    'button_size' => array(
                        'type' => 'select',
                        'title' => JText::_('Button Size'),
                        'desc' => JText::_('Set the size for multiple buttons.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'uk-button-small' => JText::_('Small'),
                            'uk-button-large' => JText::_('Large'),
                        ),
                        'depends' => array(array('button_title', '!=', '')),
                    ),
                    'button_shape' => array(
                        'type' => 'select',
                        'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
                        'values' => array(
                            'rounded' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
                            'square' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
                            'round' => JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
                        ),
                        'depends' => array(
                            array('button_style', '!=', 'link'),
                            array('button_style', '!=', 'link-muted'),
                            array('button_style', '!=', 'link-text'),
                            array('button_style', '!=', 'text'),
                        )
                    ),
                    'button_width' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Full width button'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                        'depends' => array(array('button_title', '!=', '')),
                    ),
                    'button_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'class' => array(
                        'type' => 'text',
                        'title' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
                        'std' => ''
                    ),
                ),
                'options' => PageBuilder::general_options()
            ),
        )
    );
}