<?php

/**
 * @package Jollyany Add-ons SP Page Builder
 * @author TemPlaza https://templaza.com
 * @copyright Copyright (c) 2015 - 2019 TemPlaza
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');

SpAddonsConfig::addonConfig(
	array(
		'type' => 'repeatable',
		'addon_name' => 'uicallout',
		'title' => JText::_('UI Callout'),
		'icon'=>JURI::root() . 'plugins/sppagebuilder/jollyany/addons/uicallout/assets/images/icon.png',
		'category' => 'Jollyany',
		'attr' => array(
			'general' => array(
				'admin_label' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std' => '',
				),
				'title_addon' => array(
					'type' => 'text',
					'title' => JText::_('Title'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std' =>  '',
				),
				'title_heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_margin' => array(
					'type' => 'select',
					'title' => JText::_('Title Margin'),
					'desc' => JText::_('Set the vertical margin for title.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'uk-margin-small' => JText::_('Small'),
						'uk-margin' => JText::_('Default'),
						'uk-margin-medium' => JText::_('Medium'),
						'uk-margin-large' => JText::_('Large'),
						'uk-margin-xlarge' => JText::_('X-Large'),
						'uk-margin-remove-vertical' => JText::_('None'),
					),
					'std' => 'uk-margin',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the heading with a divider, bullet or a line that is vertically centered to the heading'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_color' => array(
					'type' => 'select',
					'title' => JText::_('Color'),
					'desc' => JText::_('Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.'),
					'values' => array(
						'' => JText::_('None'),
						'text-muted' => JText::_('Muted'),
						'text-emphasis' => JText::_('Emphasis'),
						'text-primary' => JText::_('Primary'),
						'text-secondary' => JText::_('Secondary'),
						'text-success' => JText::_('Success'),
						'text-warning' => JText::_('Warning'),
						'text-danger' => JText::_('Danger'),
						'text-background' => JText::_('Background'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),

				'title_heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the seven heading elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				// Repeatable Items
				'ui_grid_item' => array(
					'title' => JText::_('Items'),
					'attr' => array(
						'card_title' => array(
							'type' => 'text',
							'title' => JText::_('Title'),
							'std' =>  'Title',
						),
						'label_text' => array(
							'type' => 'text',
							'title' => JText::_('Label'),
							'desc' => JText::_('To position a badge inside a grid item.'),
							'std' => '',
						),
						'label_styles' => array(
							'type' => 'select',
							'title' => JText::_('Label Style'),
							'desc' => JText::_('Indicate important notes and highlight parts of your content.'),
							'values' => array(
								'' => JText::_('Default'),
								'uk-label-success' => JText::_('Success'),
								'uk-label-warning' => JText::_('Warning'),
								'uk-label-danger' => JText::_('Danger'),
							),
							'depends' => array(array('label_text', '!=', '')),
						),
						'meta' => array(
							'type' => 'text',
							'title' => JText::_('Meta'),
						),
						'card_content' => array(
							'type' => 'editor',
							'title' => JText::_('Content'),
							'std' => 'Lorem Ipsum is simply text the printing and typesetting standard industry. So you like a demo website and you want to add.'
						),
						'media_type' => array(
							'type' => 'select',
							'title' => JText::_('Media Type'),
							'desc' => JText::_('Select icon or image info box type from the list'),
							'values' => array(
								'' => JText::_('Image'),
								'fontawesome_icon' => JText::_('FontAwesome'),
								'uikit_icon' => JText::_('Uikit'),
								'custom' => JText::_('Custom'),
							),
							'std' => '',
						),
						'image' => array(
							'type' => 'media',
							'title' => JText::_('Select Image'),
							'placeholder' => 'http://www.example.com/my-photo.jpg',
							'show_input' => true,
							'depends' => array(
								array('media_type', '!=', 'fontawesome_icon'),
								array('media_type', '!=', 'uikit_icon'),
								array('media_type', '!=', 'custom')
							),
						),
						'alt_text' => array(
							'type' => 'text',
							'title' => JText::_('Image Alt'),
							'std' => 'Image Alt',
							'depends' => array(
								array('media_type', '!=', 'fontawesome_icon'),
								array('media_type', '!=', 'uikit_icon'),
								array('media_type', '!=', 'custom')
							),
						),
						'uikit' => array( // New Uikit Icon
							'type' => 'select',
							'title' => JText::_('Uikit Icon'),
							'desc' => JText::_('Select an SVG icon from the list. Learn more <a href="https://getuikit.com/docs/icon#library" target="_blank">https://getuikit.com/docs/icon</a>'),
							'values' => array(
								'' => JText::_('Select an optional icon.'),
								'home' => 'Home',
								'sign-in' => 'Sign-in',
								'sign-out' => 'Sign-out',
								'user' => 'User',
								'users' => 'Users',
								'lock' => 'Lock',
								'unlock' => 'Unlock',
								'settings' => 'Settings',
								'cog' => 'Cog',
								'nut' => 'Nut',
								'comment' => 'Comment',
								'commenting' => 'Commenting',
								'comments' => 'Comments',
								'hashtag' => 'Hashtag',
								'tag' => 'Tag',
								'cart' => 'Cart',
								'credit-card' => 'Credit-card',
								'mail' => 'Mail',
								'receiver' => 'Receiver',
								'search' => 'Search',
								'location' => 'Location',
								'bookmark' => 'Bookmark',
								'code' => 'Code',
								'paint-bucket' => 'Paint-bucket',
								'camera' => 'Camera',
								'bell' => 'Bell',
								'bolt' => 'Bolt',
								'star' => 'Star',
								'heart' => 'Heart',
								'happy' => 'Happy',
								'lifesaver' => 'Lifesaver',
								'rss' => 'Rss',
								'social' => 'Social',
								'git-branch' => 'Git-branch',
								'git-fork' => 'Git-fork',
								'world' => 'World',
								'calendar' => 'Calendar',
								'clock' => 'Clock',
								'history' => 'History',
								'future' => 'Future',
								'pencil' => 'Pencil',
								'trash' => 'Trash',
								'move' => 'Move',
								'link' => 'Link',
								'question' => 'Question',
								'info' => 'Info',
								'warning' => 'Warning',
								'image' => 'Image',
								'thumbnails' => 'Thumbnails',
								'table' => 'Table',
								'list' => 'List',
								'menu' => 'Menu',
								'grid' => 'Grid',
								'more' => 'More',
								'more-vertical' => 'More-vertical',
								'plus' => 'Plus',
								'plus-circle' => 'Plus-circle',
								'minus' => 'Minus',
								'minus-circle' => 'Minus-circle',
								'close' => 'Close',
								'check' => 'Check',
								'ban' => 'Ban',
								'refresh' => 'Refresh',
								'play' => 'Play',
								'play-circle' => 'Play-circle',
								'tv' => 'Tv',
								'desktop' => 'Desktop',
								'laptop' => 'Laptop',
								'tablet' => 'Tablet',
								'phone' => 'Phone',
								'tablet-landscape' => 'Tablet-landscape',
								'phone-landscape' => 'Phone-landscape',
								'file' => 'File',
								'copy' => 'Copy',
								'file-edit' => 'File-edit',
								'folder' => 'Folder',
								'album' => 'Album',
								'push' => 'Push',
								'pull' => 'Pull',
								'server' => 'Server',
								'database' => 'Database',
								'cloud-upload' => 'Cloud-upload',
								'cloud-download' => 'Cloud-download',
								'download' => 'Download',
								'upload' => 'Upload',
								'reply' => 'Reply',
								'forward' => 'Forward',
								'expand' => 'Expand',
								'shrink' => 'Shrink',
								'arrow-up' => 'Arrow-up',
								'arrow-down' => 'Arrow-down',
								'arrow-left' => 'Arrow-left',
								'arrow-right' => 'Arrow-right',
								'chevron-up' => 'Chevron-up',
								'chevron-down' => 'Chevron-down',
								'chevron-left' => 'Chevron-left',
								'chevron-right' => 'Chevron-right',
								'triangle-up' => 'Triangle-up',
								'triangle-down' => 'Triangle-down',
								'triangle-left' => 'Triangle-left',
								'triangle-right' => 'Triangle-right',
								'bold' => 'Bold',
								'italic' => 'Italic',
								'strikethrough' => 'Strikethrough',
								'video-camera' => 'Video-camera',
								'quote-right' => 'Quote-right',
								'500px' => '500px',
								'behance' => 'Behance',
								'dribbble' => 'Dribbble',
								'facebook' => 'Facebook',
								'flickr' => 'Flickr',
								'foursquare' => 'Foursquare',
								'github' => 'Github',
								'github-alt' => 'Github-alt',
								'gitter' => 'Gitter',
								'google' => 'Google',
								'google-plus' => 'Google-plus',
								'instagram' => 'Instagram',
								'joomla' => 'Joomla',
								'linkedin' => 'Linkedin',
								'pagekit' => 'Pagekit',
								'pinterest' => 'Pinterest',
								'soundcloud' => 'Soundcloud',
								'tripadvisor' => 'Tripadvisor',
								'tumblr' => 'Tumblr',
								'twitter' => 'Twitter',
								'uikit' => 'Uikit',
								'etsy' => 'Etsy',
								'vimeo' => 'Vimeo',
								'whatsapp' => 'Whatsapp',
								'wordpress' => 'Wordpress',
								'xing' => 'Xing',
								'yelp' => 'Yelp',
								'youtube' => 'Youtube',
								'print' => 'Print',
								'reddit' => 'Reddit',
								'file-text' => 'File Text',
								'file-pdf' => 'File Pdf',
								'chevron-double-left' => 'Chevron Double Left',
								'chevron-double-right' => 'Chevron Double Right',
							),
							'std' => 'check',
							'depends' => array(
								array('media_type', '=', 'uikit_icon'),
							),							
						),
						'custom_icon' => array(
							'type' => 'text',
							'title' => JText::_('Icon Class Name'),
							'placeholder' => 'flaticon-check',
							'depends' => array(
								array('media_type', '=', 'custom'),
							),
						),
						'faw_icon' => array(
							'type' => 'icon',
							'title' => JText::_('Icon'),
							'std'=> '',
							'depends' => array(
								array('media_type', '=', 'fontawesome_icon'),
							),
						),
						'title_link' => array(
							'type' => 'media',
							'format' => 'attachment',
							'title' => JText::_('Link'),
							'placeholder' => 'http://www.example.com',
							'std' => '',
							'hide_preview' => true,
						),
						'button_title' => array(
							'type' => 'text',
							'title' => JText::_('Link Text'),
							'std' => 'Read more',
							'depends' => array(
								array('title_link', '!=', ''),
							),
						),
						'item_css' => array(
							'type' => 'text',
							'title' => JText::_('Css Class'),
							'std' => '',
						),	
					),
				),
				'separator_gallery_options' => array(
					'type' => 'separator',
					'title' => JText::_('Grid'),
				),
				'masonry' => array(
					'type' => 'checkbox',
					'title' => JText::_('Enable masonry effect'),
					'desc' => JText::_('The masonry effect creates a layout free of gap even if grid cell have different height.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'grid_parallax' => array(
					'type' => 'slider',
					'title' => JText::_('Parallax'),
					'desc' => JText::_('To move single columns of a grid at different speeds while scrolling'),
					'min' => 0,
					'max' => 600,
					'std' => '',
				),
				'grid_column_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Column Gap'),
					'desc' => JText::_('Set the size of the gap between the grid columns.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
				),
				'grid_row_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Row Gap'),
					'desc' => JText::_('Set the size of the gap between the grid rows.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
				),
				'grid_divider' => array(
					'type' => 'checkbox',
					'title' => JText::_('Show dividers'),
					'desc' => JText::_('Select this option to separate grid cells with lines.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(
						array('grid_column_gap', '!=', 'collapse'),
						array('grid_row_gap', '!=', 'collapse'),
					),
				),
				'grid_column_align' => array(
					'type' => 'checkbox',
					'title' => JText::_('Center columns'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'grid_row_align' => array(
					'type' => 'checkbox',
					'title' => JText::_('Center rows'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'separator_columns_options' => array(
					'type' => 'separator',
					'title' => JText::_('Columns'),
				),
				'phone_portrait' => array(
					'type' => 'select',
					'title' => JText::_('Phone Portrait'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '1'
				),
				'phone_landscape' => array(
					'type' => 'select',
					'title' => JText::_('Phone Landscape'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => ''
				),
				'tablet_landscape' => array(
					'type' => 'select',
					'title' => JText::_('Tablet Landscape'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => '3'
				),
				'desktop' => array(
					'type' => 'select',
					'title' => JText::_('Desktop'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => ''
				),
				'large_screens' => array(
					'type' => 'select',
					'title' => JText::_('Large Screens'),
					'desc' => JText::_('Set the number of grid columns for each breakpoint. Inherit refers to the number of columns on the next smaller screen size.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'1' => JText::_('1 Columns'),
						'2' => JText::_('2 Columns'),
						'3' => JText::_('3 Columns'),
						'4' => JText::_('4 Columns'),
						'5' => JText::_('5 Columns'),
						'6' => JText::_('6 Columns'),
						'auto' => JText::_('Auto'),
					),
					'std' => ''
				),

				'separator_card_options' => array(
					'type' => 'separator',
					'title' => JText::_('Card'),
				),
				'card_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select one of the boxed card styles or a blank panel.'),
					'values' => array(
						'' => JText::_('None'),
						'default' => JText::_('Card Default'),
						'primary' => JText::_('Card Primary'),
						'secondary' => JText::_('Card Secondary'),
						'hover' => JText::_('Card Hover'),
					),
					'std' => '',
				),
				'panel_link' => array(
					'type' => 'checkbox',
					'title' => JText::_('Link Card'),
					'desc' => JText::_('Link the whole card if a link exists.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'card_size' => array(
					'type' => 'select',
					'title' => JText::_('Padding'),
					'desc' => JText::_('Define the card\'s size by selecting the padding between the card and its content.'),
					'values' => array(
						'' => JText::_('Default'),
						'uk-card-small' => JText::_('Small'),
						'uk-card-large' => JText::_('Large'),
					),
					'std' => '',
					'depends' => array(array('card_style', '!=', '')),
				),
				'image_padding' => array(
					'type' => 'checkbox',
					'title' => JText::_('Align image without padding'),
					'desc' => JText::_('This option won\'t have any effect unless card styles are enabled. The image boder, box shadow and hover box shadow are disabled if you use this option.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends'=>array(array('card_style', '!=', '')),
				),
				'card_content_padding' => array(
					'type' => 'select',
					'title' => JText::_('Padding'),
					'desc' => JText::_('Add padding to the content if the image is top, bottom, left or right aligned.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'default' => JText::_('Default'),
						'large' => JText::_('Large'),
					),
					'std' => '',
					'depends' => array(array('card_alignment', '!=', 'between'), array('card_style', '=', '')),
				),
				'card_width' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '',
				),
				'separator_img_options' => array(
					'type' => 'separator',
					'title' => JText::_('Image'),
				),
				'img_width' => array(
					'type' => 'slider',
					'title'=>JText::_('Width'),
					'desc'=>JText::_('Setting just one value preserves the original proportions. The image will be resized and cropped automatically.'),
					'min'=> 10,
                    'max'=> 1200,
				),
				'image_border' => array(
					'type' => 'select',
					'title' => JText::_('Border'),
					'desc' => JText::_('Select the image\'s border style.'),
					'values' => array(
						'' => JText::_('None'),
						'uk-border-circle' => JText::_('Circle'),
						'uk-border-rounded' => JText::_('Rounded'),
						'uk-border-pill' => JText::_('Pill'),
					),
					'std' => '',
					'depends' => array(
						array('image_padding', '!=', 1),
					),
				),
				'image_box_shadow' => array(
					'type' => 'select',
					'title' => JText::_('Box Shadow'),
					'desc' => JText::_('Select the image\'s box shadow size.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
					'depends' => array(
						array('card_style', '=', '')
					),
				),
				'image_link' => array(
					'type' => 'checkbox',
					'title' => JText::_('Link image'),
					'desc' => JText::_('Link the image if a link exists.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'image_transition' => array(
					'type' => 'select',
					'title' => JText::_('Hover Transition'),
					'desc' => JText::_('Set the hover transition for a linked image.'),
					'values' => array(
						'' => JText::_('None'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
					),
					'std' => '',
					'depends' => array(
						array('image_link', '=', 1)
					),
				),
				'image_hover_box_shadow' => array(
					'type' => 'select',
					'title' => JText::_('Hover Box Shadow'),
					'desc' => JText::_('Select the image\'s box shadow size on hover.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
					),
					'std' => '',
					'depends' => array(
						array('card_style', '=', ''),
						array('image_link', '=', 1)
					),
				),
				'card_alignment' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the image to the top, left, right or place it between the title and the content'),
					'values' => array(
						'top' => JText::_('Top'),
						'bottom' => JText::_('Bottom'),
						'left' => JText::_('Left'),
						'right' => JText::_('Right'),
						'between' => JText::_('Between'),
					),
					'std' => 'top',
				),
				'grid_width' => array(
					'type' => 'select',
					'title' => JText::_('Grid Width'),
					'desc' => JText::_('Define the width of the image within the grid. Choose between percent and fixed widths or expand columns to the width of their content.'),
					'values' => array(
						'auto' => JText::_('Auto'),
						'4-5' => JText::_('80%'),
						'3-4' => JText::_('75%'),
						'2-3' => JText::_('66%'),
						'3-5' => JText::_('60%'),
						'1-2' => JText::_('50%'),
						'2-5' => JText::_('40%'),
						'1-3' => JText::_('33%'),
						'1-4' => JText::_('25%'),
						'1-5' => JText::_('20%'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '1-2',
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'bottom'),
						array('card_alignment', '!=', 'between'),
					),
				),
				'image_grid_column_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Grid Column Gap'),
					'desc' => JText::_('Set the size of the gap between the image and the content.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'bottom'),
						array('card_alignment', '!=', 'between'),
					),
				),
				'image_grid_row_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Grid Row Gap'),
					'desc' => JText::_('Set the size of the gap if the grid items stack.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'bottom'),
						array('card_alignment', '!=', 'between'),
					),
				),
				'grid_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Grid Breakpoint'),
					'desc' => JText::_('Set the breakpoint from which grid cells will stack.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => 'm',
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'bottom'),
						array('card_alignment', '!=', 'between'),
					),
				),
				'vertical_alignment' => array(
					'type' => 'checkbox',
					'title' => JText::_('Vertical Alignment'),
					'desc' => JText::_('Vertically center grid cells.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'bottom'),
						array('card_alignment', '!=', 'between'),
					),
				),
				'image_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('card_alignment', '!=', 'top'),
						array('card_alignment', '!=', 'left'),
						array('card_alignment', '!=', 'right'),
					),
				),
				'image_svg_inline'=>array(
					'type'=>'checkbox',
					'title'=>JText::_('Inline SVG'),
					'desc'=>JText::_('Inject SVG images into the page markup, so that they can easily be styled with CSS.'),
					'std'=>0,
				),
				'image_svg_color'=>array(
					'type'=>'select',
					'title'=>JText::_('SVG Color'),
					'desc'=>JText::_('Select the SVG color. It will only apply to supported elements defined in the SVG.'),
					'values'=>array(
						''=>JText::_('None'),
						'muted'=>JText::_('Muted'),
						'emphasis'=>JText::_('Emphasis'),
						'primary'=>JText::_('Primary'),
						'secondary'=>JText::_('Secondary'),
						'success'=>JText::_('Success'),
						'warning'=>JText::_('Warning'),
						'danger'=>JText::_('Danger'),
					),
					'std'=>'',
					'depends'=>array(
						array('image_svg_inline', '=', 1)
					),
				),
				'separator_icon_options' => array(
					'type' => 'separator',
					'title' => JText::_('Icon'),
				),
				'faw_icon_size'=>array(
					'type'=>'slider',
					'title'=>JText::_('Icon Size'),
					'placeholder'=>20,
					'std'=>'20',
					'max'=> 400,
				),
				'color' => array(
					'type' => 'color',
					'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'std' => '',
				),
				'separator_title_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Title'),
				),
				'title_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-title { font-family: {{ VALUE }}; }',
					)
				),
				'font_weight' => array(
					'type' => 'select',
					'title' => JText::_('Font weight'),
					'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
					'values' => array(
					  '' => JText::_('Default'),
					  'light' => JText::_('Light'),
					  'normal' => JText::_('Normal'),
					  'bold' => JText::_('Bold'),
					  'lighter' => JText::_('Lighter'),
					  'bolder' => JText::_('Bolder'),
					),
				),
				'heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'link_title' => array(
					'type' => 'checkbox',
					'title' => JText::_('Link Title'),
					'desc' => JText::_('Link the title if a link exists.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'title_hover_style' => array(
					'type' => 'select',
					'title' => JText::_('Hover Style'),
					'desc' => JText::_('Set the hover style for a linked title.'),
					'values' => array(
						'reset' => JText::_('None'),
						'heading' => JText::_('Heading Link'),
						'' => JText::_('Default Link'),
					),
					'std' => 'reset',
					'depends' => array(
						array('link_title', '=', 1)
					),
				),
				'title_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the title with a divider, bullet or a line that is vertically centered to the title'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
				),
				'title_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined title text color.'),
					'values' => array(
						'' => JText::_('Custom'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_title_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Custom Color'),
					'depends' => array(
						array('title_color', '=', '')
					),
				),
				'title_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the six heading elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
						'div' => JText::_('Div'),
					),
					'std' => 'h3',
				),
				'title_align' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the title to the top or left in regards to the content.'),
					'values' => array(
						'' => JText::_('Top'),
						'left' => JText::_('Left'),
					),
					'std' => '',
				),
				'title_grid_width' => array(
					'type' => 'select',
					'title' => JText::_('Grid Width'),
					'desc' => JText::_('Define the width of the title within the grid. Choose between percent and fixed widths or expand columns to the width of their content.'),
					'values' => array(
						'auto' => JText::_('Auto'),
						'4-5' => JText::_('80%'),
						'3-4' => JText::_('75%'),
						'2-3' => JText::_('66%'),
						'3-5' => JText::_('60%'),
						'1-2' => JText::_('50%'),
						'2-5' => JText::_('40%'),
						'1-3' => JText::_('33%'),
						'1-4' => JText::_('25%'),
						'1-5' => JText::_('20%'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '1-2',
					'depends' => array(
						array('title_align', '!=', ''),
					),
				),
				'title_grid_column_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Grid Column Gap'),
					'desc' => JText::_('Set the size of the gap between the title and the content.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('title_align', '!=', ''),
					),
				),
				'title_grid_row_gap' => array( 
					'type' => 'select',
					'title' => JText::_('Grid Row Gap'),
					'desc' => JText::_('Set the size of the gap if the grid items stack.'),
					'values' => array(
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'' => JText::_('Default'),
						'large' => JText::_('Large'),
						'collapse' => JText::_('None'),
					),
					'std' => '',
					'depends' => array(
						array('title_align', '!=', ''),
					),
				),
				'title_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Grid Breakpoint'),
					'desc' => JText::_('Set the breakpoint from which grid cells will stack.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => 'm',
					'depends' => array(
						array('title_align', '!=', ''),
					),
				),
				'title_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_meta_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Meta'),
				),
				'meta_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-meta { font-family: {{ VALUE }}; }',
					)
				),
				'meta_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
					'values' => array(
						'' => JText::_('None'),
						'text-meta' => JText::_('Meta'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'meta_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined meta text color.'),
					'values' => array(
						'' => JText::_('Custom'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_meta_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Custom Color'),
					'depends' => array(
						array('meta_color', '=', '')
					),
				),
				'meta_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'meta_alignment' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the meta text above or below the title.'),
					'values' => array(
						'top' => JText::_('Above Title'),
						'' => JText::_('Below Title'),
						'above' => JText::_('Above Content'),
						'content' => JText::_('Below Content'),
					),
					'std' => '',
				),
				'meta_element' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
						'div' => JText::_('Div'),
					),
					'std' => 'div',
				),
				'meta_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => 'small',
				),
				'separator_content_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Content'),
				),
				'content_font_family'=>array(
					'type'=>'fonts',
					'title'=>JText::_('Font Family'),
					'selector'=> array(
						'type'=>'font',
						'font'=>'{{ VALUE }}',
						'css'=>'.ui-content { font-family: {{ VALUE }}; }',
					)
				),
				'content_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
					'values' => array(
						'' => JText::_('None'),
						'text-lead' => JText::_('Lead'),
						'text-meta' => JText::_('Meta'),
					),
					'std' => '',
				),
				'content_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Color'),
				),
				'content_dropcap' => array(
					'type' => 'checkbox',
					'title' => JText::_('Drop Cap'),
					'desc' => JText::_('Display the first letter of the paragraph as a large initial.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'content_column' => array(
					'type' => 'select',
					'title' => JText::_('Columns'),
					'desc' => JText::_('Set the number of text columns.'),
					'values' => array(
						'' => JText::_('None'),
						'1-2' => JText::_('Halves'),
						'1-3' => JText::_('Thirds'),
						'1-4' => JText::_('Quarters'),
						'1-5' => JText::_('Fifths'),
						'1-6' => JText::_('Sixths'),
					),
					'std' => '',
				),
				'content_column_divider' => array(
					'type' => 'checkbox',
					'title' => JText::_('Show dividers'),
					'desc' => JText::_('Show a divider between text columns.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(array('content_column', '!=', '')),
				),
				'content_column_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Columns Breakpoint'),
					'desc' => JText::_('Set the device width from which the text columns should apply'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => 'm',
					'depends' => array(array('content_column', '!=', '')),
				),
				'content_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'content_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_button_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Link'),
				),
				'all_button_title' => array(
					'type' => 'text',
					'title' => JText::_('Text'),
					'std' => 'Read more',
				),
				'link_new_tab' => array(
					'type' => 'select',
					'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
					'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
					'values' => array(
						'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
						'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
					),
				),
				'button_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Set the button style.'),
					'values' => array(
						'' => JText::_('Button Default'),
						'primary' => JText::_('Button Primary'),
						'secondary' => JText::_('Button Secondary'),
						'danger' => JText::_('Button Danger'),
						'text' => JText::_('Button Text'),
						'link' => JText::_('Link'),
						'link-muted' => JText::_('Link Muted'),
						'link-text' => JText::_('Link Text'),
						'custom' => JText::_('Custom'),
					),
					'std' => 'primary',
				),				
				'separator_button_custom_options' => array(
					'type' => 'separator',
					'title' => JText::_('Custom Button Style'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
				),
				'button_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.uk-button-custom { font-family: {{ VALUE }}; }',
					)
				),
				'button_background' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
				),
				'button_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
				),
				'button_background_hover' => array(
					'type' => 'color',
					'title' => JText::_('Hover Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
				),
				'button_hover_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Hover Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
				),
				'link_button_size' => array(
					'type' => 'select',
					'title' => JText::_('Button Size'),
					'values' => array(
						'' => JText::_('Default'),
						'uk-button-small' => JText::_('Small'),
						'uk-button-large' => JText::_('Large'),
					),
				),
				'button_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_general_options' => array(
					'type' => 'separator',
					'title' => JText::_('General'),
				),
				'addon_margin' => array(
					'type' => 'select',
					'title' => JText::_('Margin'),
					'desc' => JText::_('Set the vertical margin. Note: The first element\'s top margin and the last element\'s bottom margin are always removed. Define those in the grid settings instead.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'small' => JText::_('Small'),
						'default' => JText::_('Default'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove-vertical' => JText::_('None'),
					),
					'std' => '',
				),
				'addon_max_width' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum content width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '',
				),
				'addon_max_width_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Max Width Breakpoint'),
					'desc' => JText::_('Define the device width from which the element\'s max-width will apply.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('addon_max_width', '!=', '')),
				),
				'block_align'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_breakpoint'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Breakpoint'),
					'desc'=>JText::_('Define the device width from which the alignment will apply.'),
					'values'=>array(
						''=>JText::_('Always'),
						's'=>JText::_('Small (Phone Landscape)'),
						'm'=>JText::_('Medium (Tablet Landscape)'),
						'l'=>JText::_('Large (Desktop)'),
						'xl'=>JText::_('X-Large (Large Screens)'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_fallback'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Fallback'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(
					  array('addon_max_width', '!=', ''),
					  array('block_align_breakpoint', '!=', '')
					),
				),				
				'alignment' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment'),
					'desc' => JText::_('Center, left and right alignment.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uk-text-left' => JText::_('Left'),
						'uk-text-center' => JText::_('Center'),
						'uk-text-right' => JText::_('Right'),
						'uk-text-justify' => JText::_('Justify'),
					),
					'std' => '',
				),
				'text_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Breakpoint'),
					'desc' => JText::_('Display the text alignment only on this device width and larger'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('alignment', '!=', '')),
				),
				'text_alignment_fallback' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Fallback'),
					'desc' => JText::_('Define an alignment fallback for device widths below the breakpoint'),
					'values' => array(
						'' => JText::_('Inherit'),
						'left' => JText::_('Left'),
						'center' => JText::_('Center'),
						'right' => JText::_('Right'),
						'justify' => JText::_('Justify'),
					),
					'std' => '',
					'depends' => array(
						array('text_breakpoint', '!=', ''),
						array('alignment', '!=', ''),
					),
				),
				'animation' => array(
					'type' => 'select',
					'title' => JText::_('Animation'),
					'desc' => JText::_('A collection of smooth animations to use within your page.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
						'parallax' => JText::_('Parallax'),
					),
					'std' => '',
				),
				'animation_repeat' => array(
					'type' => 'checkbox',
					'title' => JText::_('Repeat Animation'),
					'desc' => JText::_('Applies the animation class every time the element is in view'),
					'std' => 0,
					'depends' => array(
						array('animation', '!=', ''),
						array('animation', '!=', 'parallax')
					),
				),
				'delay_element_animations' => array(
					'type' => 'checkbox',
					'title' => JText::_('Delay Element Animations'),
					'desc' => JText::_('Delay element animations so that animations are slightly delayed and don\'t play all at the same time. Slide animations can come into effect with a fixed offset or at 100% of the element\’s own size.'),
					'std' => 0,
					'depends' => array(
						array('animation', '!=', ''),
						array('animation', '!=', 'parallax')
					),
				),
				'separator_parallax_options' => array(
					'type' => 'separator',
					'title' => JText::_('Parallax Animation Settings'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_start' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_end' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_start' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_end' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_start' => array(
					'type' => 'slider',
					'title' => JText::_('Scale Start'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_end' => array(
					'type' => 'slider',
					'title' => JText::_('Scale End'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_start' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate Start'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_end' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate End'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_start' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity Start'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_end' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity End'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'easing' => array(
					'type' => 'slider',
					'title' => JText::_('Easing'),
					'min' => -200,
					'max' => 200,
					'desc' => JText::_('Set the animation easing. A value below 100 is faster in the beginning and slower towards the end while a value above 100 behaves inversely.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'viewport' => array(
					'type' => 'slider',
					'title' => JText::_('Viewport'),
					'min' => 10,
					'max' => 100,
					'desc' => JText::_('Set the animation end point relative to viewport height, e.g. 50 for 50% of the viewport'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_target' => array(
					'type' => 'checkbox',
					'title' => JText::_('Target'),
					'desc' => JText::_('Animate the element as long as the section is visible.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_zindex' => array(
					'type' => 'checkbox',
					'title' => JText::_('Z Index'),
					'desc' => JText::_('Set a higher stacking order.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Breakpoint'),
					'desc' => JText::_('Display the parallax effect only on this device width and larger. It is useful to disable the parallax animation on small viewports.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone)'),
						'm' => JText::_('Medium (Tablet)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('animation', '=', 'parallax')),
				),

				'visibility' => array(
					'type' => 'select',
					'title' => JText::_('Visibility'),
					'desc' => JText::_('Display the element only on this device width and larger.'),
					'values' => array(
						'' => JText::_('Always'),
						'uk-visible@s' => JText::_('Small (Phone Landscape)'),
						'uk-visible@m' => JText::_('Medium (Tablet Landscape)'),
						'uk-visible@l' => JText::_('Large (Desktop)'),
						'uk-visible@xl' => JText::_('X-Large (Large Screens)'),
						'uk-hidden@s' => JText::_('Hidden Small (Phone Landscape)'),
						'uk-hidden@m' => JText::_('Hidden Medium (Tablet Landscape)'),
						'uk-hidden@l' => JText::_('Hidden Large (Desktop)'),
						'uk-hidden@xl' => JText::_('Hidden X-Large (Large Screens)'),
					),
					'std' => '',
				  ),
				'class' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => '',
				),
			),
		),
	)
);
