<?php

/**
 * @package Jollyany Addons SP Page Builder
 * @author TemPlaza https://templaza.com
 * @copyright Copyright (c) 2011 - 2021 TemPlaza
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');
SpAddonsConfig::addonConfig(
	array(
		'type' => 'content',
		'addon_name' => 'uisimplepricing',
		'title' => JText::_('UI Simple Pricing'),
		'desc' => JText::_('Price box allows you to display not just the cost, but also the features you wish to portray.'),
		'icon'=>JURI::root() . 'plugins/sppagebuilder/jollyany/addons/uisimplepricing/assets/images/icon.png',
		'category' => 'Jollyany',
		'attr' => array(
			'general' => array(
				'admin_label' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std' => '',
				),
				'title_addon' => array(
					'type' => 'text',
					'title' => JText::_('Add-on Title'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
					'std' =>  '',
				),
				'title_heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_margin' => array(
					'type' => 'select',
					'title' => JText::_('Title Margin'),
					'desc' => JText::_('Set the vertical margin for title.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'uk-margin-small' => JText::_('Small'),
						'uk-margin' => JText::_('Default'),
						'uk-margin-medium' => JText::_('Medium'),
						'uk-margin-large' => JText::_('Large'),
						'uk-margin-xlarge' => JText::_('X-Large'),
						'uk-margin-remove-vertical' => JText::_('None'),
					),
					'std' => 'uk-margin',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the heading with a divider, bullet or a line that is vertically centered to the heading'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_color' => array(
					'type' => 'select',
					'title' => JText::_('Color'),
					'desc' => JText::_('Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.'),
					'values' => array(
						'' => JText::_('None'),
						'text-muted' => JText::_('Muted'),
						'text-emphasis' => JText::_('Emphasis'),
						'text-primary' => JText::_('Primary'),
						'text-secondary' => JText::_('Secondary'),
						'text-success' => JText::_('Success'),
						'text-warning' => JText::_('Warning'),
						'text-danger' => JText::_('Danger'),
						'text-background' => JText::_('Background'),
					),
					'std' => '',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'title_heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'h3',
					'depends' => array(array('title_addon', '!=', '')),
				),
				'price_title' => array(
					'type' => 'text',
					'title' => JText::_('Title'),
					'std' => 'Basic',
				),
				'price_description' => array(
					'type' => 'text',
					'title' => JText::_('Description'),
					'std' => 'Free trial 30 days.',
				),
				'price' => array(
					'type' => 'text',
					'title' => JText::_('Price'),
					'desc' => JText::_('Define the price for price box'),
					'std' => '49',
				),
				'currency' => array(
					'type' => 'text',
					'title' => JText::_('Currency'),
					'placeholder' => '$',
					'std' => '$',
				),
				
				'period' => array(
					'type' => 'text',
					'title' => JText::_('Period'),
					'std' => '',
					'placeholder' => '/ monthly',
				),
				'label_text' => array(
					'type' => 'text',
					'title' => JText::_('Highlight'),
					'desc' => JText::_('Indicate important notes and highlight parts of your content.'),
					'std' => '',
					'placeholder' => 'Popular',
				),
				'label_styles' => array(
					'type' => 'select',
					'title' => JText::_('Highlight Style'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uk-label-success' => JText::_('Success'),
						'uk-label-warning' => JText::_('Warning'),
						'uk-label-danger' => JText::_('Danger'),
						'uk-label-custom' => JText::_('Custom'),
					),
					'depends' => array(array('label_text', '!=', '')),
				),
				'label_background_color' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'depends' => array(
						array('label_text', '!=', ''),
						array('label_styles', '=', 'uk-label-custom')
					),
				),
				'label_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.uk-label-custom { font-family: {{ VALUE }}; }',
					),
					'depends' => array(
						array('label_text', '!=', ''),
						array('label_styles', '=', 'uk-label-custom')
					),
				),
				'label_color' => array(
					'type' => 'color',
					'title' => JText::_('Label Color'),
					'depends' => array(
						array('label_text', '!=', ''),
						array('label_styles', '=', 'uk-label-custom')
					),
				),
				// Repeatable Item
				'ui_feature_items' => array(
					'title' => JText::_('Items'),
					'attr' => array(
						'title' => array(
							'type' => 'text',
							'title' => JText::_('Item'),
							'std' => 'Lorem ipsum dolor',
						),
						'title_link' => array(
							'type' => 'media',
							'format' => 'attachment',
							'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
							'placeholder' => 'http://www.example.com',
							'std' => '',
							'hide_preview' => true,
						),
						'link_new_tab' => array(
							'type' => 'select',
							'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
							'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
							'values' => array(
								'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
								'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
							),
							'depends' => array(array('title_link', '!=', '')),
						),
						'icon_type' => array(
							'type' => 'select',
							'title' => JText::_('Icon Type'),
							'desc' => JText::_('Select icon type from the list'),
							'values' => array(
								'' => JText::_('None'),
								'fontawesome_icon' => JText::_('FontAwesome'),
								'uikit_icon' => JText::_('Uikit'),
							),
							'std' => 'fontawesome_icon',
						),	
						'icon_name' => array(
							'type' => 'icon',
							'title' => JText::_('Icon'),
							'std'=> 'check',
							'depends' => array(
								array('icon_type', '=', 'fontawesome_icon'),
							),
						),
						'uikit' => array( // New Uikit Icon
							'type' => 'select',
							'title' => JText::_('Uikit Icon'),
							'desc' => JText::_('Select an SVG icon from the list. Learn more <a href="https://getuikit.com/docs/icon#library" target="_blank">https://getuikit.com/docs/icon</a>'),
							'values' => array(
								'' => JText::_('Select an optional icon.'),
								'home' => 'Home',
								'sign-in' => 'Sign-in',
								'sign-out' => 'Sign-out',
								'user' => 'User',
								'users' => 'Users',
								'lock' => 'Lock',
								'unlock' => 'Unlock',
								'settings' => 'Settings',
								'cog' => 'Cog',
								'nut' => 'Nut',
								'comment' => 'Comment',
								'commenting' => 'Commenting',
								'comments' => 'Comments',
								'hashtag' => 'Hashtag',
								'tag' => 'Tag',
								'cart' => 'Cart',
								'credit-card' => 'Credit-card',
								'mail' => 'Mail',
								'receiver' => 'Receiver',
								'search' => 'Search',
								'location' => 'Location',
								'bookmark' => 'Bookmark',
								'code' => 'Code',
								'paint-bucket' => 'Paint-bucket',
								'camera' => 'Camera',
								'bell' => 'Bell',
								'bolt' => 'Bolt',
								'star' => 'Star',
								'heart' => 'Heart',
								'happy' => 'Happy',
								'lifesaver' => 'Lifesaver',
								'rss' => 'Rss',
								'social' => 'Social',
								'git-branch' => 'Git-branch',
								'git-fork' => 'Git-fork',
								'world' => 'World',
								'calendar' => 'Calendar',
								'clock' => 'Clock',
								'history' => 'History',
								'future' => 'Future',
								'pencil' => 'Pencil',
								'trash' => 'Trash',
								'move' => 'Move',
								'link' => 'Link',
								'question' => 'Question',
								'info' => 'Info',
								'warning' => 'Warning',
								'image' => 'Image',
								'thumbnails' => 'Thumbnails',
								'table' => 'Table',
								'list' => 'List',
								'menu' => 'Menu',
								'grid' => 'Grid',
								'more' => 'More',
								'more-vertical' => 'More-vertical',
								'plus' => 'Plus',
								'plus-circle' => 'Plus-circle',
								'minus' => 'Minus',
								'minus-circle' => 'Minus-circle',
								'close' => 'Close',
								'check' => 'Check',
								'ban' => 'Ban',
								'refresh' => 'Refresh',
								'play' => 'Play',
								'play-circle' => 'Play-circle',
								'tv' => 'Tv',
								'desktop' => 'Desktop',
								'laptop' => 'Laptop',
								'tablet' => 'Tablet',
								'phone' => 'Phone',
								'tablet-landscape' => 'Tablet-landscape',
								'phone-landscape' => 'Phone-landscape',
								'file' => 'File',
								'copy' => 'Copy',
								'file-edit' => 'File-edit',
								'folder' => 'Folder',
								'album' => 'Album',
								'push' => 'Push',
								'pull' => 'Pull',
								'server' => 'Server',
								'database' => 'Database',
								'cloud-upload' => 'Cloud-upload',
								'cloud-download' => 'Cloud-download',
								'download' => 'Download',
								'upload' => 'Upload',
								'reply' => 'Reply',
								'forward' => 'Forward',
								'expand' => 'Expand',
								'shrink' => 'Shrink',
								'arrow-up' => 'Arrow-up',
								'arrow-down' => 'Arrow-down',
								'arrow-left' => 'Arrow-left',
								'arrow-right' => 'Arrow-right',
								'chevron-up' => 'Chevron-up',
								'chevron-down' => 'Chevron-down',
								'chevron-left' => 'Chevron-left',
								'chevron-right' => 'Chevron-right',
								'triangle-up' => 'Triangle-up',
								'triangle-down' => 'Triangle-down',
								'triangle-left' => 'Triangle-left',
								'triangle-right' => 'Triangle-right',
								'bold' => 'Bold',
								'italic' => 'Italic',
								'strikethrough' => 'Strikethrough',
								'video-camera' => 'Video-camera',
								'quote-right' => 'Quote-right',
								'500px' => '500px',
								'behance' => 'Behance',
								'dribbble' => 'Dribbble',
								'facebook' => 'Facebook',
								'flickr' => 'Flickr',
								'foursquare' => 'Foursquare',
								'github' => 'Github',
								'github-alt' => 'Github-alt',
								'gitter' => 'Gitter',
								'google' => 'Google',
								'google-plus' => 'Google-plus',
								'instagram' => 'Instagram',
								'joomla' => 'Joomla',
								'linkedin' => 'Linkedin',
								'pagekit' => 'Pagekit',
								'pinterest' => 'Pinterest',
								'soundcloud' => 'Soundcloud',
								'tripadvisor' => 'Tripadvisor',
								'tumblr' => 'Tumblr',
								'twitter' => 'Twitter',
								'uikit' => 'Uikit',
								'etsy' => 'Etsy',
								'vimeo' => 'Vimeo',
								'whatsapp' => 'Whatsapp',
								'wordpress' => 'Wordpress',
								'xing' => 'Xing',
								'yelp' => 'Yelp',
								'youtube' => 'Youtube',
								'print' => 'Print',
								'reddit' => 'Reddit',
								'file-text' => 'File Text',
								'file-pdf' => 'File Pdf',
								'chevron-double-left' => 'Chevron Double Left',
								'chevron-double-right' => 'Chevron Double Right',
							),
							'std' => 'check',
							'depends' => array(
								array('icon_type', '=', 'uikit_icon'),
							),
						),
						'icon_color' => array(
							'type' => 'color',
							'title' => JText::_('Icon color'),
							'depends' => array(array('icon_type', '!=', '')),
						),
					),
				),

				'separator_header_options' => array(
					'type' => 'separator',
					'title' => JText::_('Header'),
				),
				'header_card_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select on of the boxed card styles or a blank card.'),
					'values' => array(
						'' => JText::_('None'),
						'default' => JText::_('Default'),
						'muted' => JText::_('Muted'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'custom' => JText::_('Custom'),
					),
					'std' => '',
				),
				'header_background_color' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'depends' => array(
						array('header_card_style', '=', 'custom')
					),
				),
				'header_padding_top' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Top'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'header_padding_bottom' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Bottom'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'header_padding_left' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Left'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'header_padding_right' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Right'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'divider_type' => array(
					'type' => 'select',
					'title' => JText::_('Divider'),
					'desc' => JText::_('Create dividers to separate content and apply different styles to them.'),
					'values' => array(
						'' => JText::_('None'),
						'icon' => JText::_('Icon'),
						'small' => JText::_('Small'),
					),
					'std' => '',
				),
				'divider_color' => array(
					'type' => 'color',
					'title' => JText::_('Divider Color'),
					'depends' => array(array('divider_type', '=', 'small')),
				),
				'divider_height' => array(
					'type' => 'slider',
					'min' => 1,
					'max' => 100,
					'std' => 1,
					'title' => JText::_('Divider Height'),
					'depends' => array(array('divider_type', '=', 'small')),
				),
				'divider_align' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the divider above or below the price.'),
					'values' => array(
						'' => JText::_('Below Price'),
						'top' => JText::_('Above Price'),
					),
					'depends' => array(
						array('divider_type', '!=', ''),
					),
					'std' => '',
				),			
				'use_header_background' => array(
					'type' => 'checkbox',
					'title' => JText::_('Use Header Background'),
					'desc' => JText::_('Applies the background image for header with blend modes option. This feature will replace the background color.'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
				),
				'header_image' => array(
					'type' => 'media',
					'title' => JText::_('Image'),
					'placeholder' => 'http://www.example.com/my-photo.jpg',
					'depends' => array(array('use_header_background', '=', '1')),
				),
				'image_blend_bg_color' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'desc' => JText::_('Use the background color in combination with blend modes, a transparent image or to fill the area, if the image doesn\'t cover the whole section.'),
					'depends' => array(array('use_header_background', '=', '1')),
				),
				'image_blend_modes' => array(
					'type' => 'select',
					'title' => JText::_('Blend modes'),
					'desc' => JText::_('Apply different blend modes to your backgrounds, for example when placing them on images.'),
					'values' => array(
						'uk-background-blend-multiply' => JText::_('Multiply'),
						'uk-background-blend-screen' => JText::_('Screen'),
						'uk-background-blend-overlay' => JText::_('Overlay'),
						'uk-background-blend-darken' => JText::_('Darken'),
						'uk-background-blend-lighten' => JText::_('Lighten'),
						'uk-background-blend-color-dodge' => JText::_('Color Dodge'),
						'uk-background-blend-color-burn' => JText::_('Color Burn'),
						'uk-background-blend-hard-light' => JText::_('Hard Light'),
						'uk-background-blend-soft-light' => JText::_('Soft Light'),
						'uk-background-blend-difference' => JText::_('Difference'),
						'uk-background-blend-exclusion' => JText::_('Exclusion'),
						'uk-background-blend-hue' => JText::_('Hue'),
						'uk-background-blend-saturation' => JText::_('Saturation'),
						'uk-background-blend-color' => JText::_('Color'),
						'uk-background-blend-luminosity' => JText::_('Luminosity'),
					),
					'std' => 'uk-background-blend-soft-light',
					'depends' => array(array('use_header_background', '=', '1')),
				),
				'media_overlay' => array(
					'type' => 'color',
					'title' => JText::_('Overlay Color'),
					'desc' => JText::_('Set an additional transparent overlay to soften the image.'),
					'depends' => array(
						array('use_header_background', '=', 1)
					),
				),
				'bg_content_inverse' => array(
					'type' => 'select',
					'title' => JText::_('Inverse'),
					'desc' => JText::_('Choose Light or Dark mode option so that elements will be optimized for better visibility on dark or light images.'),
					'values' => array(
						'light' => JText::_('Light'),
						'' => JText::_('None'),
						'dark' => JText::_('Dark'),
					),
					'std' => '',
					'depends' => array(array('use_header_background', '=', '1')),
				),
				'separator_price_options' => array(
					'type' => 'separator',
					'title' => JText::_('Price'),
				),
				'price_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.tz-price { font-family: {{ VALUE }}; }',
					)
				),
				'price_heading' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => 'heading-medium',
					'depends' => array(array('price', '!=', '')),
				),
				'price_fontsize' => array(
					'type' => 'slider',
					'title' => JText::_('Font Size'),
					'std' => '70',
					'max' => 200,
					'depends' => array(
						array('price_heading', '=', '')
					),
				),
				'price_padding_left' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Left'),
					'std' => '25',
					'max' => 200,
				),
				'price_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined price color. If the background option is selected, you can use Light or Dark color text mode to inverse the text style.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_price_color' => array(
					'type' => 'color',
					'title' => JText::_('Color'),
					'depends' => array(
						array('price_color', '=', '')
					),
				),
				'price_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => 'small',
				),
				'separator_price_symbol_options' => array(
					'type' => 'separator',
					'title' => JText::_('Symbol'),
				),
				'currency_fontsize' => array(
					'type' => 'slider',
					'title' => JText::_('Currency Font Size'),
					'std' => '25',
					'max' => 100,
				),
				'currency_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Currency Color'),
					'desc' => JText::_('Select the predefined currency text color. If the background option is selected, you can use Light or Dark color text mode to inverse the text style.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_currency_color' => array(
					'type' => 'color',
					'title' => JText::_('Color'),
					'depends' => array(
						array('currency_color', '=', '')
					),
				),
				'currency_margin' => array(
					'type' => 'slider',
					'title' => JText::_('Currency Margin Top'),
					'std' => '15',
					'max' => 100,
				),
				'separator_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Body'),
				),
				'body_background_color' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
				),
				'body_padding_top' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Top'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'body_padding_bottom' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Bottom'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'body_padding_left' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Left'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'body_padding_right' => array(
					'type' => 'slider',
					'title' => JText::_('Padding Right'),
					'std' => '25',
					'min' => 0,
					'max' => 100,
				),
				'box_shadow' => array(
					'type' => 'select',
					'title' => JText::_('Box shadow'),
					'desc' => JText::_('You can apply different box shadows to elements. Just add one of the following classes.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('Xlarge'),
					),
					'std' => '',
				),
				'hover' => array(
					'type' => 'select',
					'title' => JText::_('Hover Effect'),
					'desc' => JText::_('To apply a box shadow on hover, add one of the following classes.'),
					'values' => array(
						'' => JText::_('No'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('Xlarge'),
					),
					'std' => '',
				),
				'separator_list_options' => array(
					'type' => 'separator',
					'title' => JText::_('List Items'),
				),
				'title_text_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Use one of these classes to apply a different color to text elements.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_title_text_color' => array(
					'type' => 'color',
					'title' => JText::_('Color'),
					'depends' => array(
						array('title_text_color', '=', '')
					),
				),

				'list_marker' => array(
					'type' => 'select',
					'title' => JText::_('Marker'),
					'desc' => JText::_('Select the marker of the list items.'),
					'values' => array(
						'' => JText::_('None'),
						'disc' => JText::_('Disc'),
						'circle' => JText::_('Circle'),
						'square' => JText::_('Square'),
						'decimal' => JText::_('Decimal'),
						'hyphen' => JText::_('Hyphen'),
						'bullet' => JText::_('Image Bullet'),
					),
					'std' => '',
				),

				'list_marker_color' => array(
					'type' => 'select',
					'title' => JText::_('Marker Color'),
					'desc' => JText::_('Select the color of the list markers.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
					),
					'std' => '',
				),

				'list_styles' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select the list style.'),
					'values' => array(
						'' => JText::_('None'),
						'divider' => JText::_('Divider'),
						'striped' => JText::_('Striped'),
					),
					'std' => '',
				),
				'scrollable' => array(
					'type' => 'select',
					'title' => JText::_('Scrollable panel'),
					'desc' => JText::_('Use this option if its content exceeds the height'),
					'values' => array(
						'' => JText::_('JNO'),
						'uk-panel-scrollable' => JText::_('JYES'),
					),
				),
				'list_title_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.uk-list .ui-item { font-family: {{ VALUE }}; }',
					)
				),
				'separator_title_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Title'),
				),
				'heading_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
					'values' => array(
						'' => JText::_('None'),
						'heading-2xlarge' => JText::_('2XLarge'),
						'heading-xlarge' => JText::_('XLarge'),
						'heading-large' => JText::_('Large'),
						'heading-medium' => JText::_('Medium'),
						'heading-small' => JText::_('Small'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'title_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.ui-title { font-family: {{ VALUE }}; }',
					)
				),
				'font_weight' => array(
					'type' => 'select',
					'title' => JText::_('Font weight'),
					'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
					'values' => array(
					  '' => JText::_('Default'),
					  'light' => JText::_('Light'),
					  'normal' => JText::_('Normal'),
					  'bold' => JText::_('Bold'),
					  'lighter' => JText::_('Lighter'),
					  'bolder' => JText::_('Bolder'),
					),
				),
				'title_decoration' => array(
					'type' => 'select',
					'title' => JText::_('Decoration'),
					'desc' => JText::_('Decorate the title with a divider, bullet or a line that is vertically centered to the title'),
					'values' => array(
						'' => JText::_('None'),
						'uk-heading-divider' => JText::_('Divider'),
						'uk-heading-bullet' => JText::_('Bullet'),
						'uk-heading-line' => JText::_('Line'),
					),
					'std' => '',
				),
				'title_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined title text color.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_title_color' => array(
					'type' => 'color',
					'title' => JText::_('Custom Color'),
					'depends' => array(
						array('title_color', '=', '')
					),
				),
				'title_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'heading_selector' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'h3',
				),
				'title_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_description_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Description'),
				),
				'meta_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
					'values' => array(
						'' => JText::_('None'),
						'text-meta' => JText::_('Meta'),
						'text-lead' => JText::_('Lead'),
						'h1' => JText::_('H1'),
						'h2' => JText::_('H2'),
						'h3' => JText::_('H3'),
						'h4' => JText::_('H4'),
						'h5' => JText::_('H5'),
						'h6' => JText::_('H6'),
					),
					'std' => '',
				),
				'meta_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.ui-meta { font-family: {{ VALUE }}; }',
					),
				),
				'meta_color' => array(
					'type' => 'select',
					'title' => JText::_('Predefined Color'),
					'desc' => JText::_('Select the predefined meta text color.'),
					'values' => array(
						'' => JText::_('None'),
						'muted' => JText::_('Muted'),
						'emphasis' => JText::_('Emphasis'),
						'primary' => JText::_('Primary'),
						'secondary' => JText::_('Secondary'),
						'success' => JText::_('Success'),
						'warning' => JText::_('Warning'),
						'danger' => JText::_('Danger'),
					),
					'std' => '',
				),
				'custom_meta_color' => array(
					'type' => 'color',
					'title' => JText::_('Custom Color'),
					'depends' => array(
						array('meta_color', '=', ''),
					),
				),
				'meta_text_transform' => array(
					'type' => 'select',
					'title' => JText::_('Transform'),
					'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uppercase' => JText::_('Uppercase'),
						'capitalize' => JText::_('Capitalize'),
						'lowercase' => JText::_('Lowercase'),
					),
					'std' => '',
				),
				'meta_alignment' => array(
					'type' => 'select',
					'title' => JText::_('Alignment'),
					'desc' => JText::_('Align the meta text above or below the title.'),
					'values' => array(
						'top' => JText::_('Above Title'),
						'' => JText::_('Below Title'),
						'content' => JText::_('Below Pricing'),
					),
					'std' => '',
				),
				'meta_element' => array(
					'type' => 'select',
					'title' => JText::_('HTML Element'),
					'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
					'values' => array(
						'h1' => JText::_('h1'),
						'h2' => JText::_('h2'),
						'h3' => JText::_('h3'),
						'h4' => JText::_('h4'),
						'h5' => JText::_('h5'),
						'h6' => JText::_('h6'),
						'div' => JText::_('div'),
					),
					'std' => 'div',
				),
				'meta_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),

				'separator_icon_options' => array(
					'type' => 'separator',
					'title' => JText::_('Icon'),
				),
				'all_icon_type' => array(
					'type' => 'select',
					'title' => JText::_('Icon Type'),
					'desc' => JText::_('Select icon type from the list'),
					'values' => array(
						'' => JText::_('None'),
						'fontawesome_icon' => JText::_('FontAwesome'),
						'uikit_icon' => JText::_('Uikit'),
					),
					'std' => 'fontawesome_icon',
				),	
				'all_icon_name' => array(
					'type' => 'icon',
					'title' => JText::_('Icon'),
					'std'=> '',
					'depends' => array(
						array('all_icon_type', '=', 'fontawesome_icon'),
					),
				),
				'all_uikit' => array( // New Uikit Icon
					'type' => 'select',
					'title' => JText::_('Uikit Icon'),
					'desc' => JText::_('Select an SVG icon from the list. Learn more <a href="https://getuikit.com/docs/icon#library" target="_blank">https://getuikit.com/docs/icon</a>'),
					'values' => array(
							'' => JText::_('Select an optional icon.'),
							'home' => 'Home',
							'sign-in' => 'Sign-in',
							'sign-out' => 'Sign-out',
							'user' => 'User',
							'users' => 'Users',
							'lock' => 'Lock',
							'unlock' => 'Unlock',
							'settings' => 'Settings',
							'cog' => 'Cog',
							'nut' => 'Nut',
							'comment' => 'Comment',
							'commenting' => 'Commenting',
							'comments' => 'Comments',
							'hashtag' => 'Hashtag',
							'tag' => 'Tag',
							'cart' => 'Cart',
							'credit-card' => 'Credit-card',
							'mail' => 'Mail',
							'receiver' => 'Receiver',
							'search' => 'Search',
							'location' => 'Location',
							'bookmark' => 'Bookmark',
							'code' => 'Code',
							'paint-bucket' => 'Paint-bucket',
							'camera' => 'Camera',
							'bell' => 'Bell',
							'bolt' => 'Bolt',
							'star' => 'Star',
							'heart' => 'Heart',
							'happy' => 'Happy',
							'lifesaver' => 'Lifesaver',
							'rss' => 'Rss',
							'social' => 'Social',
							'git-branch' => 'Git-branch',
							'git-fork' => 'Git-fork',
							'world' => 'World',
							'calendar' => 'Calendar',
							'clock' => 'Clock',
							'history' => 'History',
							'future' => 'Future',
							'pencil' => 'Pencil',
							'trash' => 'Trash',
							'move' => 'Move',
							'link' => 'Link',
							'question' => 'Question',
							'info' => 'Info',
							'warning' => 'Warning',
							'image' => 'Image',
							'thumbnails' => 'Thumbnails',
							'table' => 'Table',
							'list' => 'List',
							'menu' => 'Menu',
							'grid' => 'Grid',
							'more' => 'More',
							'more-vertical' => 'More-vertical',
							'plus' => 'Plus',
							'plus-circle' => 'Plus-circle',
							'minus' => 'Minus',
							'minus-circle' => 'Minus-circle',
							'close' => 'Close',
							'check' => 'Check',
							'ban' => 'Ban',
							'refresh' => 'Refresh',
							'play' => 'Play',
							'play-circle' => 'Play-circle',
							'tv' => 'Tv',
							'desktop' => 'Desktop',
							'laptop' => 'Laptop',
							'tablet' => 'Tablet',
							'phone' => 'Phone',
							'tablet-landscape' => 'Tablet-landscape',
							'phone-landscape' => 'Phone-landscape',
							'file' => 'File',
							'copy' => 'Copy',
							'file-edit' => 'File-edit',
							'folder' => 'Folder',
							'album' => 'Album',
							'push' => 'Push',
							'pull' => 'Pull',
							'server' => 'Server',
							'database' => 'Database',
							'cloud-upload' => 'Cloud-upload',
							'cloud-download' => 'Cloud-download',
							'download' => 'Download',
							'upload' => 'Upload',
							'reply' => 'Reply',
							'forward' => 'Forward',
							'expand' => 'Expand',
							'shrink' => 'Shrink',
							'arrow-up' => 'Arrow-up',
							'arrow-down' => 'Arrow-down',
							'arrow-left' => 'Arrow-left',
							'arrow-right' => 'Arrow-right',
							'chevron-up' => 'Chevron-up',
							'chevron-down' => 'Chevron-down',
							'chevron-left' => 'Chevron-left',
							'chevron-right' => 'Chevron-right',
							'triangle-up' => 'Triangle-up',
							'triangle-down' => 'Triangle-down',
							'triangle-left' => 'Triangle-left',
							'triangle-right' => 'Triangle-right',
							'bold' => 'Bold',
							'italic' => 'Italic',
							'strikethrough' => 'Strikethrough',
							'video-camera' => 'Video-camera',
							'quote-right' => 'Quote-right',
							'500px' => '500px',
							'behance' => 'Behance',
							'dribbble' => 'Dribbble',
							'facebook' => 'Facebook',
							'flickr' => 'Flickr',
							'foursquare' => 'Foursquare',
							'github' => 'Github',
							'github-alt' => 'Github-alt',
							'gitter' => 'Gitter',
							'google' => 'Google',
							'google-plus' => 'Google-plus',
							'instagram' => 'Instagram',
							'joomla' => 'Joomla',
							'linkedin' => 'Linkedin',
							'pagekit' => 'Pagekit',
							'pinterest' => 'Pinterest',
							'soundcloud' => 'Soundcloud',
							'tripadvisor' => 'Tripadvisor',
							'tumblr' => 'Tumblr',
							'twitter' => 'Twitter',
							'uikit' => 'Uikit',
							'etsy' => 'Etsy',
							'vimeo' => 'Vimeo',
							'whatsapp' => 'Whatsapp',
							'wordpress' => 'Wordpress',
							'xing' => 'Xing',
							'yelp' => 'Yelp',
							'youtube' => 'Youtube',
							'print' => 'Print',
							'reddit' => 'Reddit',
							'file-text' => 'File Text',
							'file-pdf' => 'File Pdf',
							'chevron-double-left' => 'Chevron Double Left',
							'chevron-double-right' => 'Chevron Double Right',
					),
					'std' => 'check',
					'depends' => array(
						array('all_icon_type', '=', 'uikit_icon'),
					),							
				),
				'all_icon_color' => array(
					'type' => 'color',
					'title' => JText::_('Icon color'),
					'depends' => array(array('all_icon_type', '!=', '')),
				),			
				'icon_size'=>array(
					'type'=>'slider',
					'title'=>JText::_('Icon Size'),
					'placeholder'=>20,
					'std'=>'20',
					'max'=> 400,
				),

				'separator_button_style_options' => array(
					'type' => 'separator',
					'title' => JText::_('Link'),
				),
				'button_title' => array(
					'type' => 'text',
					'title' => JText::_('Text'),
					'std' => 'Learn More',
				),
				'button_link' => array(
					'type' => 'media',
					'format' => 'attachment',
					'title' => JText::_('Link'),
					'placeholder' => 'http://www.example.com',
					'hide_preview' => true,
				),
				'button_link_new_tab' => array(
					'type' => 'select',
					'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
					'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
					'values' => array(
						'' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
						'_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
					),
				),
				'button_style' => array(
					'type' => 'select',
					'title' => JText::_('Style'),
					'desc' => JText::_('Set the button style.'),
					'values' => array(
						'' => JText::_('Button Default'),
						'primary' => JText::_('Button Primary'),
						'secondary' => JText::_('Button Secondary'),
						'danger' => JText::_('Button Danger'),
						'text' => JText::_('Button Text'),
						'link' => JText::_('Link'),
						'link-muted' => JText::_('Link Muted'),
						'link-text' => JText::_('Link Text'),
						'custom' => JText::_('Custom'),
					),
					'std' => '',
					'depends' => array(array('button_title', '!=', '')),
				),
				'separator_button_custom_options' => array(
					'type' => 'separator',
					'title' => JText::_('Custom Button Style'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_font_family' => array(
					'type' => 'fonts',
					'title' => JText::_('Font Family'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					),
					'selector' => array(
						'type' => 'font',
						'font' => '{{ VALUE }}',
						'css' => '.uk-button-custom { font-family: {{ VALUE }}; }',
					)
				),
				'button_background' => array(
					'type' => 'color',
					'title' => JText::_('Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_color' => array(
					'type' => 'color',
					'title' => JText::_('Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_background_hover' => array(
					'type' => 'color',
					'title' => JText::_('Hover Background Color'),
					'std' => '#1e87f0',
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_hover_color' => array(
					'type' => 'color',
					'title' => JText::_('Hover Button Color'),
					'depends' => array(
						array('button_style', '=', 'custom'),
					)
				),
				'button_size' => array(
					'type' => 'select',
					'title' => JText::_('Button Size'),
					'desc' => JText::_('Set the size for multiple buttons.'),
					'values' => array(
						'' => JText::_('Default'),
						'uk-button-small' => JText::_('Small'),
						'uk-button-large' => JText::_('Large'),
					),
					'depends' => array(array('button_title', '!=', '')),
				),
				'button_width' => array(
					'type' => 'checkbox',
					'title' => JText::_('Full width button'),
					'values' => array(
						1 => JText::_('JYES'),
						0 => JText::_('JNO'),
					),
					'std' => 0,
					'depends' => array(array('button_title', '!=', '')),
				),
				'button_margin_top' => array(
					'type' => 'select',
					'title' => JText::_('Margin Top'),
					'desc' => JText::_('Set the top margin.'),
					'values' => array(
						'' => JText::_('Default'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove' => JText::_('None'),
					),
					'std' => '',
				),
				'separator_general_options' => array(
					'type' => 'separator',
					'title' => JText::_('General'),
				),
				'addon_margin' => array(
					'type' => 'select',
					'title' => JText::_('Margin'),
					'desc' => JText::_('Set the vertical margin. Note: The first element\'s top margin and the last element\'s bottom margin are always removed. Define those in the grid settings instead.'),
					'values' => array(
						'' => JText::_('Keep existing'),
						'small' => JText::_('Small'),
						'default' => JText::_('Default'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'remove-vertical' => JText::_('None'),
					),
					'std' => '',
				),
				'addon_max_width' => array(
					'type' => 'select',
					'title' => JText::_('Max Width'),
					'desc' => JText::_('Set the maximum content width.'),
					'values' => array(
						'' => JText::_('None'),
						'small' => JText::_('Small'),
						'medium' => JText::_('Medium'),
						'large' => JText::_('Large'),
						'xlarge' => JText::_('X-Large'),
						'2xlarge' => JText::_('2X-Large'),
					),
					'std' => '',
				),
				'addon_max_width_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Max Width Breakpoint'),
					'desc' => JText::_('Define the device width from which the element\'s max-width will apply.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('addon_max_width', '!=', '')),
				),
				'block_align'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_breakpoint'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Breakpoint'),
					'desc'=>JText::_('Define the device width from which the alignment will apply.'),
					'values'=>array(
						''=>JText::_('Always'),
						's'=>JText::_('Small (Phone Landscape)'),
						'm'=>JText::_('Medium (Tablet Landscape)'),
						'l'=>JText::_('Large (Desktop)'),
						'xl'=>JText::_('X-Large (Large Screens)'),
					),
					'std'=>'',
					'depends'=>array(array('addon_max_width', '!=', '')),
				),
				'block_align_fallback'=>array(
					'type'=>'select',
					'title'=>JText::_('Block Alignment Fallback'),
					'desc'=>JText::_('Define the alignment in case the container exceeds the element\'s max-width.'),
					'values'=>array(
						''=>JText::_('Left'),
						'center'=>JText::_('Center'),
						'right'=>JText::_('Right'),
					),
					'std'=>'',
					'depends'=>array(
						array('addon_max_width', '!=', ''),
						array('block_align_breakpoint', '!=', '')
					),
				),
				'alignment' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment'),
					'desc' => JText::_('Center, left and right alignment.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'uk-text-left' => JText::_('Left'),
						'uk-text-center' => JText::_('Center'),
						'uk-text-right' => JText::_('Right'),
						'uk-text-justify' => JText::_('Justify'),
					),
					'std' => '',
				),
				'text_breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Breakpoint'),
					'desc' => JText::_('Display the text alignment only on this device width and larger'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone Landscape)'),
						'm' => JText::_('Medium (Tablet Landscape)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('alignment', '!=', '')),
				),
				'text_alignment_fallback' => array(
					'type' => 'select',
					'title' => JText::_('Text Alignment Fallback'),
					'desc' => JText::_('Define an alignment fallback for device widths below the breakpoint'),
					'values' => array(
						'' => JText::_('Inherit'),
						'left' => JText::_('Left'),
						'center' => JText::_('Center'),
						'right' => JText::_('Right'),
						'justify' => JText::_('Justify'),
					),
					'std' => '',
					'depends' => array(
						array('text_breakpoint', '!=', ''),
						array('alignment', '!=', ''),
					),
				),
				'animation' => array(
					'type' => 'select',
					'title' => JText::_('Animation'),
					'desc' => JText::_('A collection of smooth animations to use within your page.'),
					'values' => array(
						'' => JText::_('Inherit'),
						'fade' => JText::_('Fade'),
						'scale-up' => JText::_('Scale Up'),
						'scale-down' => JText::_('Scale Down'),
						'slide-top-small' => JText::_('Slide Top Small'),
						'slide-bottom-small' => JText::_('Slide Bottom Small'),
						'slide-left-small' => JText::_('Slide Left Small'),
						'slide-right-small' => JText::_('Slide Right Small'),
						'slide-top-medium' => JText::_('Slide Top Medium'),
						'slide-bottom-medium' => JText::_('Slide Bottom Medium'),
						'slide-left-medium' => JText::_('Slide Left Medium'),
						'slide-right-medium' => JText::_('Slide Right Medium'),
						'slide-top' => JText::_('Slide Top 100%'),
						'slide-bottom' => JText::_('Slide Bottom 100%'),
						'slide-left' => JText::_('Slide Left 100%'),
						'slide-right' => JText::_('Slide Right 100%'),
						'parallax' => JText::_('Parallax'),
					),
					'std' => '',
				),
				'animation_repeat' => array(
					'type' => 'checkbox',
					'title' => JText::_('Repeat Animation'),
					'desc' => JText::_('Applies the animation class every time the element is in view'),
					'std' => 0,
					'depends' => array(
						array('animation', '!=', ''),
						array('animation', '!=', 'parallax'),
					),
				),
				'separator_parallax_options' => array(
					'type' => 'separator',
					'title' => JText::_('Parallax Animation Settings'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_start' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'horizontal_end' => array(
					'type' => 'slider',
					'title' => JText::_('Horizontal End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the horizontal position (translateX) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_start' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical Start'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'vertical_end' => array(
					'type' => 'slider',
					'title' => JText::_('Vertical End'),
					'min' => -600,
					'max' => 600,
					'desc' => JText::_('Animate the vertical position (translateY) in pixels.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_start' => array(
					'type' => 'slider',
					'title' => JText::_('Scale Start'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'scale_end' => array(
					'type' => 'slider',
					'title' => JText::_('Scale End'),
					'min' => 50,
					'max' => 200,
					'desc' => JText::_('Animate the scaling. Min: 50, Max: 200 =>  100 means 100% scale, 200 means 200% scale, and 50 means 50% scale.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_start' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate Start'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'rotate_end' => array(
					'type' => 'slider',
					'title' => JText::_('Rotate End'),
					'min' => 0,
					'max' => 360,
					'desc' => JText::_('Animate the rotation clockwise in degrees.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_start' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity Start'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'opacity_end' => array(
					'type' => 'slider',
					'title' => JText::_('Opacity End'),
					'min' => 0,
					'max' => 100,
					'desc' => JText::_('Animate the opacity. 100 means 100% opacity, and 0 means 0% opacity.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'easing' => array(
					'type' => 'slider',
					'title' => JText::_('Easing'),
					'min' => -200,
					'max' => 200,
					'desc' => JText::_('Set the animation easing. A value below 100 is faster in the beginning and slower towards the end while a value above 100 behaves inversely.'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'viewport' => array(
					'type' => 'slider',
					'title' => JText::_('Viewport'),
					'min' => 10,
					'max' => 100,
					'desc' => JText::_('Set the animation end point relative to viewport height, e.g. 50 for 50% of the viewport'),
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_target' => array(
					'type' => 'checkbox',
					'title' => JText::_('Target'),
					'desc' => JText::_('Animate the element as long as the section is visible.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'parallax_zindex' => array(
					'type' => 'checkbox',
					'title' => JText::_('Z Index'),
					'desc' => JText::_('Set a higher stacking order.'),
					'std' => 0,
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'breakpoint' => array(
					'type' => 'select',
					'title' => JText::_('Breakpoint'),
					'desc' => JText::_('Display the parallax effect only on this device width and larger. It is useful to disable the parallax animation on small viewports.'),
					'values' => array(
						'' => JText::_('Always'),
						's' => JText::_('Small (Phone)'),
						'm' => JText::_('Medium (Tablet)'),
						'l' => JText::_('Large (Desktop)'),
						'xl' => JText::_('X-Large (Large Screens)'),
					),
					'std' => '',
					'depends' => array(array('animation', '=', 'parallax')),
				),
				'visibility' => array(
					'type' => 'select',
					'title' => JText::_('Visibility'),
					'desc' => JText::_('Display the element only on this device width and larger.'),
					'values' => array(
						'' => JText::_('Always'),
						'uk-visible@s' => JText::_('Small (Phone Landscape)'),
						'uk-visible@m' => JText::_('Medium (Tablet Landscape)'),
						'uk-visible@l' => JText::_('Large (Desktop)'),
						'uk-visible@xl' => JText::_('X-Large (Large Screens)'),
						'uk-hidden@s' => JText::_('Hidden Small (Phone Landscape)'),
						'uk-hidden@m' => JText::_('Hidden Medium (Tablet Landscape)'),
						'uk-hidden@l' => JText::_('Hidden Large (Desktop)'),
						'uk-hidden@xl' => JText::_('Hidden X-Large (Large Screens)'),
					),
					'std' => '',
				),
				'class' => array(
					'type' => 'text',
					'title' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std' => ''
				),
			),
		),
	)
);
