<?php

/**
 * @package   Astroid Framework
 * @author    Astroid Framework Team https://astroidframe.work
 * @copyright Copyright (C) 2023 AstroidFrame.work.
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

namespace Astroid\Element;

use Astroid\Framework;

defined('_JEXEC') or die;

class Column extends BaseElement
{
    public $section, $row, $size = 12, $component = false;
    public function __construct($data, $section, $row)
    {
        $this->section = $section;
        $this->row = $row;
        $this->size = $data['size'];
        parent::__construct($data);
    }

    public function render()
    {
        foreach ($this->_data['elements'] as $element) {
            $element = new Element($element, $this->section, $this->row, $this);
            $element_content = $element->render();
            if (!empty($element->content)) {
                $this->content .= $element_content;
            }
        }
        return $this->wrap();
    }

    protected function _getclasses()
    {
        $responsive = $this->params->get('responsive', '');
        if (!empty($responsive)) {
            $responsive = \json_decode($responsive, true);
        } else {
            $responsive = [];
        }

        $responsive_utilities = [];
        foreach ($responsive as $responsive_utility) {
            if (array_key_exists('name', $responsive_utility)) {
                $responsive_utilities[$responsive_utility['name']] = $responsive_utility['value'];
            }
        }

        $sizes = ['xs', 'sm', 'md', 'lg', 'xl'];
        foreach ($sizes as $size) {
            if ($size == 'lg') {
                $this->addClass('col-' . $size . '-' . $this->size);
                if (isset($responsive_utilities['hide_' . $size]) && $responsive_utilities['hide_' . $size] != 1) {
                    $this->addClass('hideon' . $size);
                }
            } else {
                if (isset($responsive_utilities['size_' . $size]) && $responsive_utilities['size_' . $size] != 'inherit') {
                    $this->addClass($size == 'xs' ? 'col-' . $responsive_utilities['size_' . $size] : 'col-' . $size . '-' . $responsive_utilities['size_' . $size]);
                }
                if (isset($responsive_utilities['hide_' . $size]) && $responsive_utilities['hide_' . $size] != 1) {
                    $this->addClass('hideon' . $size);
                }
            }
        }

        //Column Order
        $column_order_xl     =   intval($this->params->get('column_order_xl', 0));
        $column_order_lg     =   intval($this->params->get('column_order_lg', 0));
        $column_order_md     =   intval($this->params->get('column_order_md', 0));
        $column_order_sm     =   intval($this->params->get('column_order_sm', 0));
        $column_order_xs     =   intval($this->params->get('column_order_xs', 0));
        $this->addClass('order-xl-'.$column_order_xl);
        $this->addClass('order-lg-'.$column_order_lg);
        $this->addClass('order-md-'.$column_order_md);
        $this->addClass('order-sm-'.$column_order_sm);
        $this->addClass('order-'.$column_order_xs);

        parent::_getclasses();
    }
}
