<?php
/**
 * @package Jollyany
 * @author TemPlaza http://www.templaza.com
 * @copyright Copyright (c) 2010 - 2022 Jollyany
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
/**
 * @package Extra Addons SP Page Builder
 * @author WarpTheme https://warptheme.com
 * @copyright Copyright (c) 2015 - 2018 WarpTheme
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('Restricted access');
use Jollyany\Helper\PageBuilder;
use Joomla\CMS\Language\Text;
if (file_exists(JPATH_LIBRARIES . DIRECTORY_SEPARATOR . 'jollyany'. DIRECTORY_SEPARATOR . 'framework' . DIRECTORY_SEPARATOR . 'library' . DIRECTORY_SEPARATOR .'jollyany' . DIRECTORY_SEPARATOR . 'Helper' . DIRECTORY_SEPARATOR. 'PageBuilder.php')) {
    SpAddonsConfig::addonConfig(
        array(
            'type' => 'repeatable',
            'addon_name' => 'uktestimonialslider',
            'title' => JText::_('UK Testimonial Slider'),
            'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_PRO_DESC'),
            'icon' => JURI::root() . 'plugins/sppagebuilder/jollyany/addons/uktestimonialslider/assets/images/icon.png',
            'category' => 'Jollyany',
            'attr' => array(
                'general' => array(
                    'admin_label' => array(
                        'type' => 'text',
                        'title' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
                        'std' => '',
                    ),
                    'title_addon' => array(
                        'type' => 'text',
                        'title' => JText::_('Add-on Title'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TITLE_DESC'),
                        'std' => '',
                    ),
                    'title_heading_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
                        'values' => array(
                            '' => JText::_('None'),
                            'heading-2xlarge' => JText::_('2XLarge'),
                            'heading-xlarge' => JText::_('XLarge'),
                            'heading-large' => JText::_('Large'),
                            'heading-medium' => JText::_('Medium'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => 'h3',
                        'depends' => array(array('title_addon', '!=', '')),
                    ),
                    'title_heading_margin' => array(
                        'type' => 'select',
                        'title' => JText::_('Title Margin'),
                        'desc' => JText::_('Set the vertical margin for title.'),
                        'values' => array(
                            '' => JText::_('Keep existing'),
                            'uk-margin-small' => JText::_('Small'),
                            'uk-margin' => JText::_('Default'),
                            'uk-margin-medium' => JText::_('Medium'),
                            'uk-margin-large' => JText::_('Large'),
                            'uk-margin-xlarge' => JText::_('X-Large'),
                            'uk-margin-remove-vertical' => JText::_('None'),
                        ),
                        'std' => 'uk-margin',
                        'depends' => array(array('title_addon', '!=', '')),
                    ),
                    'title_heading_decoration' => array(
                        'type' => 'select',
                        'title' => JText::_('Decoration'),
                        'desc' => JText::_('Decorate the heading with a divider, bullet or a line that is vertically centered to the heading'),
                        'values' => array(
                            '' => JText::_('None'),
                            'uk-heading-divider' => JText::_('Divider'),
                            'uk-heading-bullet' => JText::_('Bullet'),
                            'uk-heading-line' => JText::_('Line'),
                        ),
                        'std' => '',
                        'depends' => array(array('title_addon', '!=', '')),
                    ),
                    'title_heading_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Color'),
                        'desc' => JText::_('Select the text color. If the Background option is selected, styles that don\'t apply a background image use the primary color instead.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'text-muted' => JText::_('Muted'),
                            'text-emphasis' => JText::_('Emphasis'),
                            'text-primary' => JText::_('Primary'),
                            'text-secondary' => JText::_('Secondary'),
                            'text-success' => JText::_('Success'),
                            'text-warning' => JText::_('Warning'),
                            'text-danger' => JText::_('Danger'),
                            'text-background' => JText::_('Background'),
                        ),
                        'std' => '',
                        'depends' => array(array('title_addon', '!=', '')),
                    ),
                    'title_heading_selector' => array(
                        'type' => 'select',
                        'title' => JText::_('HTML Element'),
                        'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
                        'values' => array(
                            'h1' => JText::_('h1'),
                            'h2' => JText::_('h2'),
                            'h3' => JText::_('h3'),
                            'h4' => JText::_('h4'),
                            'h5' => JText::_('h5'),
                            'h6' => JText::_('h6'),
                            'div' => JText::_('div'),
                        ),
                        'std' => 'h3',
                        'depends' => array(array('title_addon', '!=', '')),
                    ),
                    // Repeatable Items
                    'uk_testimonialslider_item' => array(
                        'title' => JText::_('Items'),
                        'attr' => array(
                            'title' => array(
                                'type' => 'text',
                                'title' => JText::_('Name'),
                                'std' => 'Peter Holland',
                            ),

                            'company' => array(
                                'type' => 'text',
                                'title' => JText::_('Meta'),
                                'std' => 'Customer',
                            ),
                            'avatar' => array(
                                'type' => 'media',
                                'title' => JText::_('Avatar'),
                                'placeholder' => 'http://www.example.com/my-photo.jpg',
                            ),
                            'alt_text' => array(
                                'type' => 'text',
                                'title' => JText::_('Image ALT'),
                                'placeholder' => 'Image Alt',
                                'depends' => array(
                                    array('avatar', '!=', ''),
                                ),
                            ),
                            'client_review' => array(
                                'type' => 'select',
                                'title' => JText::_('Client Rating'),
                                'values' => array(
                                    '' => JText::_('None'),
                                    '1' => JText::_('1'),
                                    '2' => JText::_('2'),
                                    '3' => JText::_('3'),
                                    '4' => JText::_('4'),
                                    '5' => JText::_('5'),
                                ),
                                'std' => '',
                            ),
                            'message' => array(
                                'type' => 'editor',
                                'title' => JText::_('Content'),
                                'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
                            ),

                            'link' => array(
                                'type' => 'media',
                                'format' => 'attachment',
                                'title' => JText::_('Link'),
                                'placeholder' => 'http://www.example.com',
                                'std' => '',
                                'hide_preview' => true,
                            ),
                        ),
                    ),
                    'separator_columns_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Item Width'),
                    ),
                    'ts_phone_portrait' => array(
                        'type' => 'select',
                        'title' => JText::_('Phone Portrait'),
                        'desc' => JText::_('Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.'),
                        'values' => array(
                            '1-1' => JText::_('100%'),
                            '5-6' => JText::_('83%'),
                            '4-5' => JText::_('80%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            '1-6' => JText::_('16%'),
                        ),
                        'std' => '1-1',
                    ),
                    'ts_phone_landscape' => array(
                        'type' => 'select',
                        'title' => JText::_('Phone Landscape'),
                        'desc' => JText::_('Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            '1-1' => JText::_('100%'),
                            '5-6' => JText::_('83%'),
                            '4-5' => JText::_('80%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            '1-6' => JText::_('16%'),
                        ),
                        'std' => '',
                    ),
                    'ts_tablet_landscape' => array(
                        'type' => 'select',
                        'title' => JText::_('Tablet Landscape'),
                        'desc' => JText::_('Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            '1-1' => JText::_('100%'),
                            '5-6' => JText::_('83%'),
                            '4-5' => JText::_('80%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            '1-6' => JText::_('16%'),
                        ),
                        'std' => '1-2',
                    ),
                    'ts_desktop' => array(
                        'type' => 'select',
                        'title' => JText::_('Desktop'),
                        'desc' => JText::_('Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            '1-1' => JText::_('100%'),
                            '5-6' => JText::_('83%'),
                            '4-5' => JText::_('80%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            '1-6' => JText::_('16%'),
                        ),
                        'std' => '',
                    ),
                    'ts_large_screens' => array(
                        'type' => 'select',
                        'title' => JText::_('Large Screens'),
                        'desc' => JText::_('Set the item width for each breakpoint. Inherit refers to the item width of the next smaller screen size.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            '1-1' => JText::_('100%'),
                            '5-6' => JText::_('83%'),
                            '4-5' => JText::_('80%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            '1-6' => JText::_('16%'),
                        ),
                        'std' => '',
                    ),
                    'grid_column_gap' => array(
                        'type' => 'select',
                        'title' => JText::_('Column Gap'),
                        'desc' => JText::_('Set the size of the gap between the grid columns.'),
                        'values' => array(
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            '' => JText::_('Default'),
                            'large' => JText::_('Large'),
                            'collapse' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'divider' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Show dividers'),
                        'desc' => JText::_('Select this option to separate grid cells with lines.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'separator_testimonial_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Testimonial'),
                    ),
                    'header_alignment' => array(
                        'type' => 'select',
                        'title' => JText::_('Header Position'),
                        'values' => array(
                            '' => JText::_('Top'),
                            'bottom' => JText::_('Bottom'),
                        ),
                        'std' => '',
                    ),
                    'header_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                        'depends' => array(array('header_alignment', '=', 'bottom')),
                    ),
                    'icon_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Rating Icon Color'),
                        'std' => '#fba311',
                    ),
                    'icon_rating' => array(
                        'type' => 'select',
                        'title' => JText::_('Rating Icon Type'),
                        'values' => array(
                            '' => JText::_('FontAwesome'),
                            'uikit' => JText::_('Uikit'),
                        ),
                        'std' => '',
                    ),
                    'rating_alignment' => array(
                        'type' => 'select',
                        'title' => JText::_('Rating Position'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'image' => JText::_('Below Image'),
                        ),
                        'std' => '',
                    ),
                    'separator_card_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Card'),
                    ),

                    'card_styles' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select one of the boxed card styles or a blank panel.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'default' => JText::_('Card Default'),
                            'primary' => JText::_('Card Primary'),
                            'secondary' => JText::_('Card Secondary'),
                            'hover' => JText::_('Card Hover'),
                            'custom' => JText::_('Custom'),
                        ),
                        'std' => '',
                    ),
                    'panel_link' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Link Card'),
                        'desc' => JText::_('Link the whole card if a link exists.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'card_background' => array(
                        'type' => 'color',
                        'title' => JText::_('Background Color'),
                        'std' => '#1e87f0',
                        'depends' => array(array('card_styles', '=', 'custom')),
                    ),
                    'card_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Color'),
                        'depends' => array(array('card_styles', '=', 'custom')),
                    ),
                    'card_size' => array(
                        'type' => 'select',
                        'title' => JText::_('Padding'),
                        'desc' => JText::_('Define the card\'s size by selecting the padding between the card and its content.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'uk-card-small' => JText::_('Small'),
                            'uk-card-large' => JText::_('Large'),
                        ),
                        'std' => '',
                        'depends' => array(array('card_styles', '!=', '')),
                    ),
                    'card_content_padding' => array(
                        'type' => 'select',
                        'title' => JText::_('Padding'),
                        'desc' => JText::_('Add padding to the content if the image is top, bottom, left or right aligned.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'small' => JText::_('Small'),
                            'default' => JText::_('Default'),
                            'large' => JText::_('Large'),
                        ),
                        'std' => '',
                        'depends' => array(array('card_styles', '=', '')),
                    ),
                    'card_border_radius' => array(
                        'type' => 'select',
                        'title' => JText::_('Card Border Radius'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'rounded' => JText::_('Rounded'),
                            'circle' => JText::_('Circle'),
                            'pill' => JText::_('Pill'),
                        ),
                        'std' => '',
                        'depends' => array(array('card_styles', '!=', '')),
                    ),
                    'card_width' => array(
                        'type' => 'select',
                        'title' => JText::_('Max Width'),
                        'desc' => JText::_('Set the maximum width.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            '2xlarge' => JText::_('2X-Large'),
                        ),
                        'std' => '',
                    ),
                    'separator_animation_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Animation'),
                    ),
                    'slidesets' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Slide all visible items at once'),
                        'desc' => JText::_('Group items into sets. The number of items within a set depends on the defined item width, e.g. 33% means that eaach set contains 3 items.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'center_slide' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Center the active slide'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'velocity' => array(
                        'type' => 'slider',
                        'title' => JText::_('Velocity'),
                        'desc' => JText::_('Set the velocity in pixels per milliseconds.'),
                        'min' => 20,
                        'max' => 300,
                    ),
                    'finite_slide' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Disable infinite scrolling'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'autoplay' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Enable autoplay'),
                        'desc' => JText::_('To activate Slider autoplays to the attribute. '),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'pause' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Pause autoplay on hover'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                        'depends' => array(
                            array('autoplay', '=', 1),
                        )
                    ),
                    'autoplay_interval' => array(
                        'type' => 'slider',
                        'title' => JText::_('Interval'),
                        'desc' => JText::_('Set the autoplay interval in seconds.'),
                        'placeholder' => '7',
                        'min' => 5,
                        'max' => 15,
                        'depends' => array(
                            array('autoplay', '=', 1),
                        )
                    ),
                    'separator_navigation_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Navigation'),
                    ),
                    'navigation' => array(
                        'type' => 'select',
                        'title' => JText::_('Navigation Display'),
                        'desc' => JText::_('Select the navigation type, show or hide navigation control.'),
                        'values' => array(
                            '' => JText::_('Hide'),
                            'dotnav' => JText::_('Dotnav'),
                        ),
                        'std' => 'dotnav',
                    ),
                    'navigation_position' => array(
                        'type' => 'select',
                        'title' => JText::_('Position'),
                        'desc' => JText::_('Select the position of the navigation.'),
                        'values' => array(
                            'left' => JText::_('Left'),
                            'center' => JText::_('Center'),
                            'right' => JText::_('Right'),
                        ),
                        'std' => 'center',
                    ),
                    'navigation_margin' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin'),
                        'desc' => JText::_('Set the vertical margin.'),
                        'values' => array(
                            'uk-margin-small-top' => JText::_('Small'),
                            'uk-margin-top' => JText::_('Default'),
                            'uk-margin-medium-top' => JText::_('Medium'),
                        ),
                        'std' => 'uk-margin-top',
                    ),
                    'navigation_breakpoint' => array(
                        'type' => 'select',
                        'title' => JText::_('Breakpoint'),
                        'desc' => JText::_('Display the navigation only on this device width and larger'),
                        'values' => array(
                            '' => JText::_('Always'),
                            's' => JText::_('Small (Phone Landscape)'),
                            'm' => JText::_('Medium (Tablet Landscape)'),
                            'l' => JText::_('Large (Desktop)'),
                            'xl' => JText::_('X-Large (Large Screens)'),
                        ),
                        'std' => 's',
                    ),
                    'navigation_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Color'),
                        'values' => array(
                            'light' => JText::_('Light'),
                            '' => JText::_('None'),
                            'dark' => JText::_('Dark'),
                        ),
                        'std' => '',
                    ),

                    'separator_slidenav_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('SlideNav'),
                    ),
                    'slidenav_position' => array(
                        'type' => 'select',
                        'title' => JText::_('Position'),
                        'desc' => JText::_('Select the position of the slidenav.'),
                        'values' => array(
                            '' => JText::_('Hide'),
                            'default' => JText::_('Default'),
                            'outside' => JText::_('Outside'),
                            'top-left' => JText::_('Top Left'),
                            'top-right' => JText::_('Top Right'),
                            'center-left' => JText::_('Center Left'),
                            'center-right' => JText::_('Center Right'),
                            'bottom-left' => JText::_('Bottom Left'),
                            'bottom-center' => JText::_('Bottom Center'),
                            'bottom-right' => JText::_('Bottom Right'),
                        ),
                        'std' => 'default',
                    ),
                    'slidenav_margin' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin'),
                        'desc' => JText::_('Apply a margin between the slidnav and the slider container.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                        ),
                        'std' => 'medium',
                    ),
                    'slidenav_breakpoint' => array(
                        'type' => 'select',
                        'title' => JText::_('Breakpoint'),
                        'desc' => JText::_('Display the slidenav on this device width and larger.'),
                        'values' => array(
                            '' => JText::_('Always'),
                            's' => JText::_('Small (Phone Landscape)'),
                            'm' => JText::_('Medium (Tablet Landscape)'),
                            'l' => JText::_('Large (Desktop)'),
                            'xl' => JText::_('X-Large (Large Screens)'),
                        ),
                        'std' => 's',
                        'depends' => array(array('slidenav_position', '!=', 'outside')),
                    ),
                    'slidenav_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Color'),
                        'desc' => JText::_('Set light or dark color mode for the slidenav.'),
                        'values' => array(
                            'light' => JText::_('Light'),
                            '' => JText::_('None'),
                            'dark' => JText::_('Dark'),
                        ),
                        'std' => '',
                        'depends' => array(array('slidenav_position', '!=', 'outside')),
                    ),
                    'slidenav_outside_breakpoint' => array(
                        'type' => 'select',
                        'title' => JText::_('Outside Breakpoint'),
                        'desc' => JText::_('Display the slidenav only outside on this device width and larger. Otherwise it will be displayed inside'),
                        'values' => array(
                            's' => JText::_('Small (Phone Landscape)'),
                            'm' => JText::_('Medium (Tablet Landscape)'),
                            'l' => JText::_('Large (Desktop)'),
                            'xl' => JText::_('X-Large (Large Screens)'),
                        ),
                        'std' => 'xl',
                        'depends' => array(array('slidenav_position', '=', 'outside')),
                    ),
                    'slidenav_outside_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Outside Color'),
                        'desc' => JText::_('Set light or dark color if the slidenav is outside of the slider'),
                        'values' => array(
                            'light' => JText::_('Light'),
                            '' => JText::_('None'),
                            'dark' => JText::_('Dark'),
                        ),
                        'std' => '',
                        'depends' => array(array('slidenav_position', '=', 'outside')),
                    ),
                    'slidenav_on_hover' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Show on hover only'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                        'depends' => array(array('slidenav_position', '!=', '')),
                    ),
                    'larger_style' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Larger style'),
                        'desc' => JText::_('To increase the size of the slidenav icons'),
                        'values' => array(
                            '0' => JText::_('JNO'),
                            '1' => JText::_('JYES'),
                        ),
                        'std' => '0',
                        'depends' => array(array('slidenav_position', '!=', '')),
                    ),
                    'separator_image_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Image'),
                    ),
                    'image_position' => array(
                        'type' => 'select',
                        'title' => JText::_('Image Position'),
                        'desc' => JText::_('Display image above/below/inline/ testimonial content or none.'),
                        'values' => array(
                            'top' => JText::_('Top'),
                            'bottom' => JText::_('Bottom'),
                            '' => JText::_('Left'),
                            'right' => JText::_('Right'),
                        ),
                        'std' => '',
                    ),
                    'image_grid_width' => array(
                        'type' => 'select',
                        'title' => JText::_('Grid Width'),
                        'desc' => JText::_('Define the width of the image within the grid. Choose between percent and fixed widths or expand columns to the width of their content.'),
                        'values' => array(
                            'auto' => JText::_('Auto'),
                            '4-5' => JText::_('80%'),
                            '3-4' => JText::_('75%'),
                            '2-3' => JText::_('66%'),
                            '3-5' => JText::_('60%'),
                            '1-2' => JText::_('50%'),
                            '2-5' => JText::_('40%'),
                            '1-3' => JText::_('33%'),
                            '1-4' => JText::_('25%'),
                            '1-5' => JText::_('20%'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            '2xlarge' => JText::_('2X-Large'),
                        ),
                        'std' => 'auto',
                        'depends' => array(
                            array('image_position', '!=', 'top'),
                            array('image_position', '!=', 'bottom'),
                        ),
                    ),
                    'image_grid_column_gap' => array(
                        'type' => 'select',
                        'title' => JText::_('Grid Column Gap'),
                        'desc' => JText::_('Set the size of the gap between the image and the content.'),
                        'values' => array(
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            '' => JText::_('Default'),
                            'large' => JText::_('Large'),
                            'collapse' => JText::_('None'),
                        ),
                        'std' => 'small',
                        'depends' => array(
                            array('image_position', '!=', 'top'),
                            array('image_position', '!=', 'bottom'),
                        ),
                    ),
                    'image_grid_breakpoint' => array(
                        'type' => 'select',
                        'title' => JText::_('Grid Breakpoint'),
                        'desc' => JText::_('Set the breakpoint from which grid cells will stack.'),
                        'values' => array(
                            '' => JText::_('Always'),
                            's' => JText::_('Small (Phone Landscape)'),
                            'm' => JText::_('Medium (Tablet Landscape)'),
                            'l' => JText::_('Large (Desktop)'),
                            'xl' => JText::_('X-Large (Large Screens)'),
                        ),
                        'std' => 'm',
                        'depends' => array(
                            array('image_position', '!=', 'top'),
                            array('image_position', '!=', 'bottom'),
                        ),
                    ),
                    'vertical_alignment' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Vertical Alignment'),
                        'desc' => JText::_('Vertically center grid cells.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 1,
                        'depends' => array(
                            array('image_position', '!=', 'top'),
                            array('image_position', '!=', 'bottom'),
                        ),
                    ),
                    'image_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                        'depends' => array(
                            array('image_position', '=', 'bottom'),
                        ),
                    ),
                    'image_link' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Link image'),
                        'desc' => JText::_('Link the image if a link exists.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'avatar_width' => array(
                        'type' => 'slider',
                        'title' => JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_WIDTH'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_TESTIMONIAL_CLIENT_AVATAR_WIDTH_DESC'),
                        'std' => 90,
                        'min' => 16,
                        'max' => 128
                    ),
                    'avatar_shape' => array(
                        'type' => 'select',
                        'title' => JText::_('Border'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'uk-border-rounded' => JText::_('Rounded'),
                            'uk-border-circle' => JText::_('Circle'),
                            'uk-border-pill' => JText::_('Pill'),
                        ),
                        'std' => 'uk-border-circle'
                    ),
                    'image_svg_inline' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Inline SVG'),
                        'desc' => JText::_('Inject SVG images into the page markup, so that they can easily be styled with CSS.'),
                        'std' => 0,
                    ),
                    'image_svg_color' => array(
                        'type' => 'select',
                        'title' => JText::_('SVG Color'),
                        'desc' => JText::_('Select the SVG color. It will only apply to supported elements defined in the SVG.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                        ),
                        'std' => '',
                        'depends' => array(
                            array('image_svg_inline', '=', 1)
                        ),
                    ),
                    'separator_name_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Name'),
                    ),

                    'title_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Name Style'),
                        'desc' => JText::_('Heading styles differ in font-size but may also come with a predefined color, size and font'),
                        'values' => array(
                            '' => JText::_('None'),
                            'heading-2xlarge' => JText::_('2XLarge'),
                            'heading-xlarge' => JText::_('XLarge'),
                            'heading-large' => JText::_('Large'),
                            'heading-medium' => JText::_('Medium'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => '',
                    ),
                    'title_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.ui-author { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'font_weight' => array(
                        'type' => 'select',
                        'title' => JText::_('Font weight'),
                        'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'light' => JText::_('Light'),
                            'normal' => JText::_('Normal'),
                            'bold' => JText::_('Bold'),
                            'lighter' => JText::_('Lighter'),
                            'bolder' => JText::_('Bolder'),
                        ),
                    ),
                    'title_text_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined title text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                            'background' => JText::_('Background'),
                        ),
                        'std' => '',
                    ),
                    'custom_title_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('title_text_color', '=', '')
                        ),
                    ),
                    'title_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'link_title' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Link Title'),
                        'desc' => JText::_('Link the title if a link exists.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'title_hover_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Hover Style'),
                        'desc' => JText::_('Set the hover style for a linked title.'),
                        'values' => array(
                            'reset' => JText::_('None'),
                            'heading' => JText::_('Heading Link'),
                            '' => JText::_('Default Link'),
                        ),
                        'std' => 'reset',
                        'depends' => array(
                            array('link_title', '=', 1)
                        ),
                    ),
                    'heading_selector' => array(
                        'type' => 'select',
                        'title' => JText::_('HTML Element'),
                        'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
                        'values' => array(
                            'h1' => JText::_('h1'),
                            'h2' => JText::_('h2'),
                            'h3' => JText::_('h3'),
                            'h4' => JText::_('h4'),
                            'h5' => JText::_('h5'),
                            'h6' => JText::_('h6'),
                            'div' => JText::_('div'),
                        ),
                        'std' => 'h3',
                    ),
                    'title_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => 'remove',
                    ),
                    'separator_meta_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Meta'),
                    ),
                    'meta_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.ui-meta { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'meta_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
                        'values' => array(
                            '' => JText::_('None'),
                            'text-meta' => JText::_('Meta'),
                            'heading-small' => JText::_('Small'),
                            'h1' => JText::_('H1'),
                            'h2' => JText::_('H2'),
                            'h3' => JText::_('H3'),
                            'h4' => JText::_('H4'),
                            'h5' => JText::_('H5'),
                            'h6' => JText::_('H6'),
                        ),
                        'std' => 'text-meta',
                    ),
                    'meta_font_weight' => array(
                        'type' => 'select',
                        'title' => JText::_('Font weight'),
                        'desc' => JText::_('Add one of the following classes to modify the font weight of your text.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'light' => JText::_('Light'),
                            'normal' => JText::_('Normal'),
                            'bold' => JText::_('Bold'),
                            'lighter' => JText::_('Lighter'),
                            'bolder' => JText::_('Bolder'),
                        ),
                    ),
                    'meta_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'meta_text_color' => array(
                        'type' => 'select',
                        'title' => JText::_('Predefined Color'),
                        'desc' => JText::_('Select the predefined meta text color.'),
                        'values' => array(
                            '' => JText::_('None'),
                            'muted' => JText::_('Muted'),
                            'emphasis' => JText::_('Emphasis'),
                            'primary' => JText::_('Primary'),
                            'secondary' => JText::_('Secondary'),
                            'success' => JText::_('Success'),
                            'warning' => JText::_('Warning'),
                            'danger' => JText::_('Danger'),
                            'light' => JText::_('Light'),
                            'dark' => JText::_('Dark'),
                        ),
                        'std' => '',
                    ),
                    'custom_meta_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Custom Color'),
                        'depends' => array(
                            array('meta_text_color', '=', '')
                        ),
                    ),
                    'meta_element' => array(
                        'type' => 'select',
                        'title' => JText::_('HTML Element'),
                        'desc' => JText::_('Choose one of the HTML elements to fit your semantic structure.'),
                        'values' => array(
                            'h1' => JText::_('h1'),
                            'h2' => JText::_('h2'),
                            'h3' => JText::_('h3'),
                            'h4' => JText::_('h4'),
                            'h5' => JText::_('h5'),
                            'h6' => JText::_('h6'),
                            'div' => JText::_('div'),
                        ),
                        'std' => 'div',
                    ),
                    'meta_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => 'remove',
                    ),
                    'separator_content_style_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Content'),
                    ),
                    'content_style' => array(
                        'type' => 'select',
                        'title' => JText::_('Style'),
                        'desc' => JText::_('Select a predefined meta text style, including color, size and font-family'),
                        'values' => array(
                            '' => JText::_('None'),
                            'text-lead' => JText::_('Lead'),
                            'text-meta' => JText::_('Meta'),
                        ),
                        'std' => '',
                    ),
                    'content_font_family' => array(
                        'type' => 'fonts',
                        'title' => JText::_('Font Family'),
                        'selector' => array(
                            'type' => 'font',
                            'font' => '{{ VALUE }}',
                            'css' => '.ui-content { font-family: {{ VALUE }}; }',
                        )
                    ),
                    'content_color' => array(
                        'type' => 'color',
                        'title' => JText::_('Color'),
                    ),
                    'content_dropcap' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Drop Cap'),
                        'desc' => JText::_('Display the first letter of the paragraph as a large initial.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                    ),
                    'content_column' => array(
                        'type' => 'select',
                        'title' => JText::_('Columns'),
                        'desc' => JText::_('Set the number of text columns.'),
                        'values' => array(
                            '' => JText::_('None'),
                            '1-2' => JText::_('Halves'),
                            '1-3' => JText::_('Thirds'),
                            '1-4' => JText::_('Quarters'),
                            '1-5' => JText::_('Fifths'),
                            '1-6' => JText::_('Sixths'),
                        ),
                        'std' => '',
                    ),
                    'content_column_divider' => array(
                        'type' => 'checkbox',
                        'title' => JText::_('Show dividers'),
                        'desc' => JText::_('Show a divider between text columns.'),
                        'values' => array(
                            1 => JText::_('JYES'),
                            0 => JText::_('JNO'),
                        ),
                        'std' => 0,
                        'depends' => array(array('content_column', '!=', '')),
                    ),
                    'content_column_breakpoint' => array(
                        'type' => 'select',
                        'title' => JText::_('Columns Breakpoint'),
                        'desc' => JText::_('Set the device width from which the text columns should apply'),
                        'values' => array(
                            '' => JText::_('Always'),
                            's' => JText::_('Small (Phone Landscape)'),
                            'm' => JText::_('Medium (Tablet Landscape)'),
                            'l' => JText::_('Large (Desktop)'),
                            'xl' => JText::_('X-Large (Large Screens)'),
                        ),
                        'std' => 'm',
                        'depends' => array(array('content_column', '!=', '')),
                    ),
                    'content_text_transform' => array(
                        'type' => 'select',
                        'title' => JText::_('Transform'),
                        'desc' => JText::_('The following options will transform text into uppercased, capitalized or lowercased characters.'),
                        'values' => array(
                            '' => JText::_('Inherit'),
                            'uppercase' => JText::_('Uppercase'),
                            'capitalize' => JText::_('Capitalize'),
                            'lowercase' => JText::_('Lowercase'),
                        ),
                        'std' => '',
                    ),
                    'content_margin_top' => array(
                        'type' => 'select',
                        'title' => JText::_('Margin Top'),
                        'desc' => JText::_('Set the top margin.'),
                        'values' => array(
                            '' => JText::_('Default'),
                            'small' => JText::_('Small'),
                            'medium' => JText::_('Medium'),
                            'large' => JText::_('Large'),
                            'xlarge' => JText::_('X-Large'),
                            'remove' => JText::_('None'),
                        ),
                        'std' => '',
                    ),
                    'separator_link_options' => array(
                        'type' => 'separator',
                        'title' => JText::_('Link'),
                    ),
                    'link_new_tab' => array(
                        'type' => 'select',
                        'title' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
                        'values' => array(
                            '' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
                            '_blank' => JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
                        ),
                    ),
                    'class' => array(
                        'type' => 'text',
                        'title' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
                        'desc' => JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
                        'std' => ''
                    ),
                ),
                'options' => PageBuilder::general_options()
            ),
        )
    );
}