/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '0', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2021-10-01 04:43:07', '0', '2021-10-01 04:43:07', '0', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '0', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '0', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '0', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '0', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '0', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '0', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '0', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '0', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('12', '1', 'com_content.article'),
('13', '1', 'com_content.article'),
('15', '1', 'com_content.article'),
('16', '1', 'com_content.article'),
('17', '1', 'com_content.article'),
('18', '1', 'com_content.article'),
('19', '1', 'com_content.article'),
('20', '1', 'com_content.article'),
('21', '1', 'com_content.article'),
('22', '1', 'com_content.article'),
('23', '1', 'com_content.article'),
('24', '1', 'com_content.article'),
('25', '1', 'com_content.article'),
('26', '1', 'com_content.article'),
('27', '1', 'com_content.article'),
('28', '1', 'com_content.article'),
('29', '1', 'com_content.article'),
('30', '1', 'com_content.article'),
('32', '1', 'com_content.article'),
('33', '1', 'com_content.article'),
('34', '1', 'com_content.article'),
('35', '1', 'com_content.article'),
('36', '1', 'com_content.article'),
('37', '1', 'com_content.article'),
('38', '1', 'com_content.article'),
('39', '1', 'com_content.article'),
('40', '1', 'com_content.article'),
('41', '1', 'com_content.article'),
('42', '1', 'com_content.article'),
('43', '1', 'com_content.article'),
('44', '1', 'com_content.article'),
('45', '1', 'com_content.article'),
('46', '1', 'com_content.article'),
('47', '1', 'com_content.article'),
('48', '1', 'com_content.article'),
('49', '1', 'com_content.article'),
('50', '1', 'com_content.article'),
('51', '1', 'com_content.article'),
('52', '1', 'com_content.article'),
('53', '1', 'com_content.article'),
('54', '1', 'com_content.article'),
('55', '1', 'com_content.article'),
('56', '1', 'com_content.article'),
('57', '1', 'com_content.article'),
('58', '1', 'com_content.article'),
('59', '1', 'com_content.article'),
('60', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(60))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime DEFAULT NULL,
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('777', 'Victoria Rawson', 'admin', 'admin@localhost', '$2y$10$sBMW2tPipJQaBoiGgFXqMuYlLAZbvcsMDfDImmEI8DGhuJ2kLmkhC', '0', '1', '2020-08-21 07:54:09', '2023-08-23 03:33:57', '0', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"astroid_author_picture\":\"gravatar\",\"upload\":\"\",\"astroid_author_aboutme\":\"Hello! I am Victoria. I\'m a creative designer and developer at TemPlaza. I enjoy creating eye candy solutions for web and mobile applications. I\'d love to work on yours, too :)\",\"astroid_author_social\":[],\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\",\"tz_portfolio_plus_user_url\":\"\",\"tz_portfolio_plus_user_gender\":\"m\",\"tz_portfolio_plus_user_avatar\":\"\",\"tz_portfolio_plus_user_twitter\":\"\",\"tz_portfolio_plus_user_facebook\":\"\",\"tz_portfolio_plus_user_instagram\":\"\",\"tz_portfolio_plus_user_description\":\"\"}', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('777', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/INSERT INTO `#__user_profiles`  VALUES 
('777', 'joomlatoken.enabled', '1', '2'),
('777', 'joomlatoken.token', 'fDFpQIps4Goxs6fUABOta1C7QnLcc5J++2qiTAHgyT0=', '1');
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_mfa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `options` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `tries` int(11) NOT NULL DEFAULT 0,
  `last_try` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('157', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '4.3.2.1', '', 'https://update.joomla.org/language/details4/af-ZA_details.xml', '', '', ''),
('158', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '4.0.2.1', '', 'https://update.joomla.org/language/details4/ar-AA_details.xml', '', '', ''),
('159', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/bg-BG_details.xml', '', '', ''),
('160', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '4.0.4.2', '', 'https://update.joomla.org/language/details4/ca-ES_details.xml', '', '', ''),
('161', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '4.3.0.2', '', 'https://update.joomla.org/language/details4/zh-CN_details.xml', '', '', ''),
('162', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '4.2.3.1', '', 'https://update.joomla.org/language/details4/zh-TW_details.xml', '', '', ''),
('163', '2', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/hr-HR_details.xml', '', '', ''),
('164', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '4.3.1.2', '', 'https://update.joomla.org/language/details4/cs-CZ_details.xml', '', '', ''),
('165', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/da-DK_details.xml', '', '', ''),
('166', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/nl-NL_details.xml', '', '', ''),
('167', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/en-AU_details.xml', '', '', ''),
('168', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/en-CA_details.xml', '', '', ''),
('169', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/en-NZ_details.xml', '', '', ''),
('170', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/en-US_details.xml', '', '', ''),
('171', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '4.3.0.1', '', 'https://update.joomla.org/language/details4/et-EE_details.xml', '', '', ''),
('172', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '4.1.1.2', '', 'https://update.joomla.org/language/details4/fi-FI_details.xml', '', '', ''),
('173', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/nl-BE_details.xml', '', '', ''),
('174', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '4.3.3.2', '', 'https://update.joomla.org/language/details4/fr-FR_details.xml', '', '', ''),
('175', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/ka-GE_details.xml', '', '', ''),
('176', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/de-DE_details.xml', '', '', ''),
('177', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/de-AT_details.xml', '', '', ''),
('178', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/de-LI_details.xml', '', '', ''),
('179', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/de-LU_details.xml', '', '', ''),
('180', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/de-CH_details.xml', '', '', ''),
('181', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/el-GR_details.xml', '', '', ''),
('182', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/hu-HU_details.xml', '', '', ''),
('183', '2', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '4.2.8.1', '', 'https://update.joomla.org/language/details4/ga-IE_details.xml', '', '', ''),
('184', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/it-IT_details.xml', '', '', ''),
('185', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/ja-JP_details.xml', '', '', ''),
('186', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '4.1.2.2', '', 'https://update.joomla.org/language/details4/kk-KZ_details.xml', '', '', ''),
('187', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/lv-LV_details.xml', '', '', ''),
('188', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/lt-LT_details.xml', '', '', ''),
('189', '2', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '4.2.4.1', '', 'https://update.joomla.org/language/details4/mk-MK_details.xml', '', '', ''),
('190', '2', '0', 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', '0', '4.0.1.1', '', 'https://update.joomla.org/language/details4/nb-NO_details.xml', '', '', ''),
('191', '2', '0', 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', '0', '4.3.2.1', '', 'https://update.joomla.org/language/details4/ps-AF_details.xml', '', '', ''),
('192', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/fa-IR_details.xml', '', '', ''),
('193', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '4.2.8.2', '', 'https://update.joomla.org/language/details4/pl-PL_details.xml', '', '', ''),
('194', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '4.0.3.1', '', 'https://update.joomla.org/language/details4/pt-BR_details.xml', '', '', ''),
('195', '2', '0', 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', '0', '4.0.0-rc4.2', '', 'https://update.joomla.org/language/details4/pt-PT_details.xml', '', '', ''),
('196', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '4.3.1.1', '', 'https://update.joomla.org/language/details4/ro-RO_details.xml', '', '', ''),
('197', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/ru-RU_details.xml', '', '', ''),
('198', '2', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '4.3.2.1', '', 'https://update.joomla.org/language/details4/sr-RS_details.xml', '', '', ''),
('199', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '4.3.2.2', '', 'https://update.joomla.org/language/details4/sr-YU_details.xml', '', '', ''),
('200', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/sk-SK_details.xml', '', '', ''),
('201', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/sl-SI_details.xml', '', '', ''),
('202', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '4.2.3.1', '', 'https://update.joomla.org/language/details4/es-ES_details.xml', '', '', ''),
('203', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/sv-SE_details.xml', '', '', ''),
('204', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/ta-IN_details.xml', '', '', ''),
('205', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '4.3.3.1', '', 'https://update.joomla.org/language/details4/th-TH_details.xml', '', '', ''),
('206', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/tr-TR_details.xml', '', '', ''),
('207', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '4.3.2.1', '', 'https://update.joomla.org/language/details4/uk-UA_details.xml', '', '', ''),
('208', '2', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '4.2.2.1', '', 'https://update.joomla.org/language/details4/vi-VN_details.xml', '', '', ''),
('209', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '4.3.4.1', '', 'https://update.joomla.org/language/details4/cy-GB_details.xml', '', '', ''),
('210', '9', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', '', ''),
('211', '9', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', '', ''),
('212', '9', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', '', ''),
('213', '9', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', '', ''),
('214', '9', '0', 'Bengali, Bangladesh', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', '', ''),
('215', '9', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.24.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', '', ''),
('216', '9', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', '', ''),
('217', '9', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', '', ''),
('218', '9', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', '', ''),
('219', '9', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', '', ''),
('220', '9', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', '', ''),
('221', '9', '0', 'Hindi, India', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', '', ''),
('222', '9', '0', 'Indonesian, Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', '', ''),
('223', '9', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', '', ''),
('224', '9', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', '', ''),
('225', '9', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', '', ''),
('226', '9', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', '', ''),
('227', '9', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', '', ''),
('228', '9', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', '', ''),
('229', '9', '0', 'Spanish, Colombia', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', '', ''),
('230', '9', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.10.12.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', '', ''),
('231', '9', '0', 'Syriac, East', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', '', ''),
('232', '9', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', '', ''),
('233', '9', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', '', ''),
('237', '34', '10114', 'Search Extension Package', 'Joomla! CMS Search Package', 'pkg_search', 'package', '', '0', '4.0.1-dev', '', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', 'https://github.com/joomla-extensions/search/releases/tag/4.0.1-dev', NULL, '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('3', '28'),
('4', '10001'),
('6', '10003'),
('8', '10004'),
('9', '10008'),
('10', '10008'),
('14', '10012'),
('15', '10023'),
('16', '10028'),
('17', '10036'),
('34', '10114'),
('35', '10117'),
('53', '10154'),
('54', '10156');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1692757852', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_4.xml', '1', '1692757883', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1692758105', '', NULL, NULL),
('4', 'Jollyany Plugin', 'extension', 'https://www.templaza.com/tzupdates/jollyany.xml', '1', '1692757886', '', NULL, NULL),
('6', 'astroid_framework', 'extension', 'https://cdn.joomdev.com/updates/astroid_system_plugin.xml', '1', '1692757886', '', NULL, NULL),
('8', 'Jollyany Template', 'extension', 'https://www.templaza.com/tzupdates/tz_educab_template.xml', '1', '1692757888', '', NULL, NULL),
('9', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist_3.xml', '1', '1692757889', '', NULL, NULL),
('10', 'Accredited Joomla! Translations', 'collection', 'http://www.joomla.org.il/translationlist_3.xml', '1', '1692757909', '', NULL, NULL),
('14', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro.xml', '1', '1692757910', '', NULL, NULL),
('15', 'AcyMailing', 'extension', 'https://api.acymailing.com/public/updatexml/component?extension=acymailing&cms=joomla&version=latest&level=starter', '1', '1692757911', '', NULL, NULL),
('16', 'TZ Portfolio Plus Component', 'extension', 'http://www.tzportfolio.com/tzupdates/tz_portfolio_plus.xml', '1', '1692757912', '', NULL, NULL),
('17', 'FOF 3.x', 'extension', 'http://cdn.akeeba.com/updates/fof3_file.xml', '1', '1692757914', '', NULL, NULL),
('34', 'Search Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', '1', '1692757914', '', NULL, NULL),
('35', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1692757915', '', NULL, NULL),
('53', 'Astroid Framework', 'extension', 'https://raw.githubusercontent.com/templaza/astroid-framework/master/astroid_framework.xml', '1', '0', '', NULL, NULL),
('54', 'Jollyany Framework', 'extension', 'https://raw.githubusercontent.com/templaza/jollyany-framework/master/jollyany_framework.xml', '1', '0', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `home` char(7) NOT NULL DEFAULT '0',
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `layout` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `preset` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_templates`  VALUES 
('1', 'elegant', 'elegant - Default', '0', '1', '', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\"}', ''),
('2', 'system', 'system - Default', '0', '1', '', '', ''),
('3', 'besley', 'besley - Default', '1', '0', '[{\"name\":\"Media\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"media\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Title\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"0 0 20px\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"10\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"title\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"\",\"col-sm\":\"\",\"col-md\":\"\",\"col-lg\":\"2\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"icons\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Information\",\"class\":\"inline-style muted\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"0 0 20px\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"created_date\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"author\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"category\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"hits\",\"customclass\":\"\",\"responsiveclass\":\"\"},{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"comment:count\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Introtext\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"introtext\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Fulltext\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"fulltext\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Password\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"password\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Extra Fields\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"extrafields\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Project Link\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"project_link\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Vote\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"vote\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Social\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"social\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Tags\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"tags\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Author Info\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"15px 0 0\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"author_about\",\"customclass\":\"\",\"responsiveclass\":\"\"}]},{\"name\":\"Related Articles\",\"class\":\"\",\"responsive\":\"\",\"backgroundcolor\":\"rgba(255, 255, 255, 0)\",\"textcolor\":\"rgba(255, 255, 255, 0)\",\"linkcolor\":\"rgba(255, 255, 255, 0)\",\"linkhovercolor\":\"rgba(255, 255, 255, 0)\",\"margin\":\"\",\"padding\":\"\",\"containertype\":\"container-fluid\",\"children\":[{\"col-xs\":\"12\",\"col-sm\":\"12\",\"col-md\":\"12\",\"col-lg\":\"12\",\"col-xs-offset\":\"\",\"col-sm-offset\":\"\",\"col-md-offset\":\"\",\"col-lg-offset\":\"\",\"type\":\"related\",\"customclass\":\"\",\"responsiveclass\":\"\"}]}]', '{\"layout\":\"default\",\"use_single_layout_builder\":\"1\",\"date_format\":\"l, d F Y H:i\",\"load_style\":\"1\",\"ratio\":\"5:3\",\"bgcolor\":\"rgba(0, 0, 0, 0.5)\",\"textcolor\":\"rgba(255, 255, 255, 1)\"}', '');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `description` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_tags`  VALUES 
('1', 'First Day', 'first-day', '1', NULL, NULL),
('2', 'New School', 'new-school', '1', NULL, NULL),
('3', 'Campus', 'campus', '1', '', NULL),
('4', 'Student Life', 'student-life', '1', NULL, NULL),
('5', 'Library', 'library', '1', NULL, NULL),
('6', 'Graduation', 'graduation', '1', NULL, NULL),
('7', 'Sports', 'sports', '1', NULL, NULL),
('8', 'Adventure', 'adventure', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_tag_content_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagsid` int(11) NOT NULL DEFAULT 0,
  `contentid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_tag_content_map`  VALUES 
('1', '1', '2'),
('2', '2', '2'),
('5', '3', '3'),
('6', '4', '3'),
('7', '3', '4'),
('9', '5', '4'),
('10', '3', '5'),
('12', '4', '5'),
('14', '4', '6'),
('17', '6', '7'),
('19', '3', '8'),
('20', '7', '8'),
('21', '3', '9'),
('22', '7', '9'),
('23', '4', '9'),
('25', '4', '10'),
('27', '8', '10'),
('28', '7', '6'),
('29', '8', '6');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  `default_value` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `advanced_search` tinyint(4) NOT NULL DEFAULT 0,
  `list_view` tinyint(4) NOT NULL DEFAULT 0,
  `detail_view` tinyint(4) NOT NULL DEFAULT 1,
  `params` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_fieldgroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `name` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `field_ordering_type` tinyint(4) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_field_fieldgroup_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldsid` int(11) NOT NULL DEFAULT 0,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_field_content_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL DEFAULT 0,
  `fieldsid` int(11) NOT NULL DEFAULT 0,
  `value` text DEFAULT NULL,
  `images` text DEFAULT NULL,
  `imagetitle` varchar(255) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_extensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(100) NOT NULL DEFAULT '',
  `element` varchar(100) NOT NULL DEFAULT '',
  `folder` varchar(100) NOT NULL DEFAULT '',
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `manifest_cache` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `access` int(10) NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_extensions`  VALUES 
('1', 'system', 'tz_portfolio_plus-template', 'system', '', '1', '{\"name\":\"system\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"July 17th 2015\",\"author\":\"DuongTVTemplaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"info@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"1.3\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '', '0', '0000-00-00 00:00:00', '1', '1', '0', '0'),
('2', 'plg_content_vote', 'tz_portfolio_plus-plugin', 'vote', 'content', '1', '{\"name\":\"plg_content_vote\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"Aug, 09th 2012\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"2.6.0\",\"description\":\"PLG_CONTENT_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '{\"show_cat_vote\":\"0\",\"show_cat_counter\":\"1\",\"cat_unrated\":\"1\",\"show_counter\":\"1\",\"unrated\":\"1\"}', '0', '2016-01-07 10:03:01', '1', '1', '0', '164'),
('3', 'plg_mediatype_image', 'tz_portfolio_plus-plugin', 'image', 'mediatype', '1', '{\"name\":\"plg_mediatype_image\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"May 4th 2021\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2021 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.6\",\"description\":\"PLG_MEDIATYPE_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '{\"image_file_size\":\"10\",\"image_file_type\":\"bmp,gif,jpg,jpeg,png,BMP,GIF,JPG,JPEG,PNG\",\"image_mime_type\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp\",\"image_size\":[\"{\\\"title\\\":\\\"XSmall\\\",\\\"width\\\":\\\"100\\\",\\\"image_name_prefix\\\":\\\"xs\\\"}\",\"{\\\"title\\\":\\\"Small\\\",\\\"width\\\":\\\"200\\\",\\\"image_name_prefix\\\":\\\"s\\\"}\",\"{\\\"title\\\":\\\"Medium\\\",\\\"width\\\":\\\"400\\\",\\\"image_name_prefix\\\":\\\"m\\\"}\",\"{\\\"title\\\":\\\"Large\\\",\\\"width\\\":\\\"600\\\",\\\"image_name_prefix\\\":\\\"l\\\"}\",\"{\\\"title\\\":\\\"XLarge\\\",\\\"width\\\":\\\"900\\\",\\\"image_name_prefix\\\":\\\"xl\\\"}\"],\"mt_image_show_feed_image\":\"1\",\"mt_image_feed_size\":\"o\",\"mt_show_cat_image_hover\":\"1\",\"mt_cat_image_size\":\"o\",\"mt_image_size\":\"o\",\"mt_show_image_hover\":\"1\",\"mt_image_use_cloud\":\"0\",\"mt_image_related_show_image\":\"1\",\"mt_image_related_size\":\"o\",\"mt_image_cloud_size\":\"o\",\"mt_image_cloud_position\":\"inside\",\"mt_image_cloud_softfocus\":\"0\",\"mt_image_cloud_show_title\":\"1\",\"mt_image_cloud_width\":\"\",\"mt_image_cloud_height\":\"\",\"mt_image_cloud_adjustX\":\"0\",\"mt_image_cloud_adjustY\":\"0\",\"mt_image_cloud_tint\":\"\",\"mt_image_cloud_tint_opacity\":\"0.5\",\"mt_image_cloud_len_opacity\":\"0.5\",\"mt_image_cloud_smoothmove\":\"3\",\"mt_image_cloud_title_opacity\":\"0.5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '171'),
('4', 'plg_extrafields_text', 'tz_portfolio_plus-plugin', 'text', 'extrafields', '1', '{\"name\":\"plg_extrafields_text\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '{\"suggestion\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '169'),
('5', 'plg_extrafields_textarea', 'tz_portfolio_plus-plugin', 'textarea', 'extrafields', '1', '{\"name\":\"plg_extrafields_textarea\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '{\"cols\":\"50\",\"rows\":\"5\",\"use_editor_back_end\":\"0\",\"use_editor_front_end\":\"0\",\"groups_can_use_frontend_editor\":\"1\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '170'),
('6', 'plg_extrafields_checkboxes', 'tz_portfolio_plus-plugin', 'checkboxes', 'extrafields', '1', '{\"name\":\"plg_extrafields_checkboxes\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '{\"number_columns\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '165'),
('7', 'plg_extrafields_dropdownlist', 'tz_portfolio_plus-plugin', 'dropdownlist', 'extrafields', '1', '{\"name\":\"plg_extrafields_dropdownlist\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_DROPDOWNLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"dropdownlist\"}', '{\"size\":\"5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '166'),
('8', 'plg_extrafields_multipleselect', 'tz_portfolio_plus-plugin', 'multipleselect', 'extrafields', '1', '{\"name\":\"plg_extrafields_multipleselect\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_MULTIPLESELECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multipleselect\"}', '{\"size\":\"5\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '167'),
('9', 'plg_extrafields_radio', 'tz_portfolio_plus-plugin', 'radio', 'extrafields', '1', '{\"name\":\"plg_extrafields_radio\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"October 20th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_EXTRAFIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '{\"bootstrap_style\":\"1\",\"number_columns\":\"0\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '168'),
('10', 'plg_user_profile', 'tz_portfolio_plus-plugin', 'profile', 'user', '1', '{\"name\":\"plg_user_profile\",\"type\":\"tz_portfolio_plus-plugin\",\"creationDate\":\"December 13th 2015\",\"author\":\"DuongTVTemPlaza\",\"copyright\":\"Copyright (C) 2015 TemPlaza. All rights reserved.\",\"authorEmail\":\"support@templaza.com\",\"authorUrl\":\"www.templaza.com\\/\",\"version\":\"2.6.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{}', '0', '0000-00-00 00:00:00', '1', '1', '0', '172'),
('11', 'elegant', 'tz_portfolio_plus-template', 'elegant', '', '1', '{\"name\":\"elegant\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"September 5th 2019\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2019 TemPlaza. All rights reserved.\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"3.1\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '0'),
('20', 'besley', 'tz_portfolio_plus-template', 'besley', '', '0', '{\"name\":\"besley\",\"type\":\"tz_portfolio_plus-template\",\"creationDate\":\"September 2021\",\"author\":\"Sonny\",\"copyright\":\"Copyright (C) 2018 TemPlaza. All rights reserved.\",\"authorEmail\":\"sonlv@templaza.com\",\"authorUrl\":\"www.templaza.com\",\"version\":\"1.6\",\"description\":\"TZ_PORTFOLIO_PLUS_TPL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"template\"}', '{\"use_single_layout_builder\":\"0\",\"load_style\":\"1\",\"ratio\":\"5:3\",\"bgcolor\":\"rgba(0, 0, 0, 0.5)\",\"textcolor\":\"rgba(255, 255, 255, 1)\"}', '0', '0000-00-00 00:00:00', '1', '1', '0', '0');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_rejected` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__tz_portfolio_plus_content table.',
  `created` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL COMMENT 'FK to the #__users table.',
  `message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  `rating_sum` int(11) NOT NULL DEFAULT 0,
  `rating_count` int(11) NOT NULL DEFAULT 0,
  KEY `extravote_idx` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_featured_map` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content_category_map` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `contentid` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `main` tinyint(4) NOT NULL COMMENT 'Main Category',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_content_category_map`  VALUES 
('1', '2', '3', '1'),
('2', '3', '3', '1'),
('3', '4', '3', '1'),
('4', '5', '3', '1'),
('5', '6', '3', '1'),
('6', '7', '3', '1'),
('7', '8', '3', '1'),
('8', '9', '3', '1'),
('9', '10', '3', '1');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Store old state to restore state',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribs` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadesc` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `media` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_id` int(11) NOT NULL DEFAULT 0,
  `priority` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_content`  VALUES 
('1', '0', '174', 'First day in school', 'first-day-in-school', '<p>Roasting coffee transforms the chemical and physical properties of green coffee beans into roasted coffee products. The roasting process is what produces the characteristic flavor of coffee by causing the green coffee beans to change in taste.</p>\r\n', '\r\n<p>Unroasted beans contain similar if not higher levels of acids, protein, sugars, and caffeine as those that have been roasted, but lack the taste of roasted coffee beans due to the Maillard and other chemical reactions that occur during roasting.</p>\r\n<blockquote>\r\n<p>The majority of coffee is roasted on a large scale, but small-scale roasting has grown with the trend toward specialty shops.</p>\r\n</blockquote>\r\n<h3> Equipment</h3>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters. Roasters can operate in either batch or continuous modes. Home roasters are also available.</p>\r\n<p><img src=\"images/tz_educab/anna-earl-6zA_-eCUtK0-unsplash.jpg\" alt=\"\" /></p>\r\n<p>Drum machines consist of horizontal rotating drums that tumble the green coffee beans in a heated environment. The heat source can be supplied by natural gas, liquefied petroleum gas (LPG), electricity, or even wood. The most common employ indirectly heated drums where the heat source is under the drum. Direct-fired roasters are roasters in which a flame contacts the beans inside the drum; very few of these machines are still in operation.</p>\r\n<blockquote>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters.</p>\r\n</blockquote>\r\n<p>Hot-air roasters force heated air through a screen or perforated plate under the coffee beans with sufficient force to lift the beans. Heat is transferred to the beans as they tumble and circulate within this fluidized bed. Some coffee roasters use names for the various degrees of roast, such as City Roast and French Roast, for the internal bean temperatures found during roasting.</p>', '1', '0', '2020-12-07 03:11:32', '777', '', '0000-00-00 00:00:00', '0', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:32', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{}', '0', '0'),
('2', '0', '175', 'First day in school', 'first-day-in-school', '<p>Roasting coffee transforms the chemical and physical properties of green coffee beans into roasted coffee products. The roasting process is what produces the characteristic flavor of coffee by causing the green coffee beans to change in taste.</p>\r\n', '\r\n<p>Unroasted beans contain similar if not higher levels of acids, protein, sugars, and caffeine as those that have been roasted, but lack the taste of roasted coffee beans due to the Maillard and other chemical reactions that occur during roasting.</p>\r\n<blockquote>\r\n<p>The majority of coffee is roasted on a large scale, but small-scale roasting has grown with the trend toward specialty shops.</p>\r\n</blockquote>\r\n<h3>Equipment</h3>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters. Roasters can operate in either batch or continuous modes. Home roasters are also available.</p>\r\n<p><img src=\"images/tz_educab/anna-earl-6zA_-eCUtK0-unsplash.jpg\" alt=\"\" /></p>\r\n<p>Drum machines consist of horizontal rotating drums that tumble the green coffee beans in a heated environment. The heat source can be supplied by natural gas, liquefied petroleum gas (LPG), electricity, or even wood. The most common employ indirectly heated drums where the heat source is under the drum. Direct-fired roasters are roasters in which a flame contacts the beans inside the drum; very few of these machines are still in operation.</p>\r\n<blockquote>\r\n<p>The most common roasting machines are of two basic types: drum and hot-air, although there are others including packed-bed, tangential and centrifugal roasters.</p>\r\n</blockquote>\r\n<p>Hot-air roasters force heated air through a screen or perforated plate under the coffee beans with sufficient force to lift the beans. Heat is transferred to the beans as they tumble and circulate within this fluidized bed. Some coffee roasters use names for the various degrees of roast, such as City Roast and French Roast, for the internal bean temperatures found during roasting.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 04:02:03', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '6', '8', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/first-day-in-school-2.jpg\"}}', '0', '0'),
('3', '0', '176', 'Campus Life', 'campus-life', '<p>As a librarian, there are certain moments that stick with me. When one of my students unexpectedly gave me a mutinous look, I knew it was the start of one of them.</p>\r\n', '\r\n<h2>LOREM IPSUM DOLOR SIT AMET</h2>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<p>Bobby had always been an affable student, but one day when I asked him to return the book he had been reading, he gave me the look. At first, I didn’t understand. It was a small ask after all. The book was brand new, one I hadn’t catalogued or even stamped with the school’s name yet. It was not ready to be loaned out.</p>\r\n<p><img src=\"images/tz_educab/daniel-zjV8ptYgcEo-unsplash.jpg\" alt=\"\" /></p>\r\n<p>It turns out, I had inadvertently stumbled upon something special. Bobby, like all the 8th-grade students in our school that year, was reading The Outsiders by S.E. Hinton. I just had received several copies of the title in large print so I asked Bobby to switch from reading his regular print to the larger text. I was curious to see if he would notice any difference between the two formats. Bobby obliged and spent the rest of the period quietly reading, but when the bell rang and it was time to return the book that’s when he gave me the look.</p>\r\n<h2>DUIS AUTE IRURE DOLOR IN REPREHENDERIT</h2>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>So I relented and let him keep the book. The next day when I asked Bobby why he didn’t want to return the book, he responded that he didn’t want to stop reading. “It was easier to read, and I didn’t lose my place as much as I usually do, especially reading and then looking up, and then going back. It was easier to find my place in the large textbook than the small textbook.”</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 04:29:03', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '4', '7', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/campus-life-3.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/campus-life-3-h.jpg\"}}', '0', '0'),
('4', '0', '177', 'Reading books in library', 'reading-books-in-library', '<p>As a librarian, there are certain moments that stick with me. When one of my students unexpectedly gave me a mutinous look, I knew it was the start of one of them.</p>\r\n', '\r\n<h2>LOREM IPSUM DOLOR SIT AMET</h2>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<p>Bobby had always been an affable student, but one day when I asked him to return the book he had been reading, he gave me the look. At first, I didn’t understand. It was a small ask after all. The book was brand new, one I hadn’t catalogued or even stamped with the school’s name yet. It was not ready to be loaned out.</p>\r\n<p><img src=\"images/tz_educab/daniel-zjV8ptYgcEo-unsplash.jpg\" alt=\"\" /></p>\r\n<p>It turns out, I had inadvertently stumbled upon something special. Bobby, like all the 8th-grade students in our school that year, was reading The Outsiders by S.E. Hinton. I just had received several copies of the title in large print so I asked Bobby to switch from reading his regular print to the larger text. I was curious to see if he would notice any difference between the two formats. Bobby obliged and spent the rest of the period quietly reading, but when the bell rang and it was time to return the book that’s when he gave me the look.</p>\r\n<h2>DUIS AUTE IRURE DOLOR IN REPREHENDERIT</h2>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>So I relented and let him keep the book. The next day when I asked Bobby why he didn’t want to return the book, he responded that he didn’t want to stop reading. “It was easier to read, and I didn’t lose my place as much as I usually do, especially reading and then looking up, and then going back. It was easier to find my place in the large textbook than the small textbook.”</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 04:34:11', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '3', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/reading-books-in-library-4.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/reading-books-in-library-4-h.jpg\"}}', '0', '0'),
('5', '0', '178', 'A day in the life at the University', 'a-day-in-the-life-at-the-university', '<p>In just a few short weeks, the normal educational schedule was thrown into chaos. Schools, colleges and universities were faced with complete shut down - no pupils, no teachers and a significantly reduced ability to deliver lessons in a meaningful way.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam hendrerit nisi sed sollicitudin pellentesque. Nunc posuere purus rhoncus pulvinar aliquam. Ut aliquet tristique nisl vitae volutpat. Nulla aliquet porttitor venenatis. Donec a dui et dui fringilla consectetur id nec massa.</p>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Despite their best efforts many schools have struggled to adapt to the current crisis, with teachers under a lot of strain to keep lessons going without systems designed to help them manage their curriculums appropriately. As time has progressed, many people (particularly parents) have asked why technology, that is increasingly used in our private lives (particularly younger generations), is not being utilised to its full potential in education. Experts in the industry are already predicting the impact of coronavirus will compel many institutions to rethink their learning strategies.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>DUIS AUTE IRURE DOLOR IN REPREHENDERIT</h3>\r\n<p>This webinar will present Open eLMS Live - a system designed to help teachers deliver a timetable of classroom learning remotely using existing teleconferencing systems and online learning resources. We are confident that you will see the benefits of running this remote learning platform now and also when your school reopens. It will also enable you to create a plan of action should a shutdown be necessary at any time in the future.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 04:39:02', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '3', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/a-day-in-the-life-at-the-university-5.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/a-day-in-the-life-at-the-university-5-h.jpg\"}}', '0', '0'),
('6', '0', '180', 'Vacation with a Mission', 'vacation-with-a-mission', '<p>In just a few short weeks, the normal educational schedule was thrown into chaos. Schools, colleges and universities were faced with complete shut down - no pupils, no teachers and a significantly reduced ability to deliver lessons in a meaningful way.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam hendrerit nisi sed sollicitudin pellentesque. Nunc posuere purus rhoncus pulvinar aliquam. Ut aliquet tristique nisl vitae volutpat. Nulla aliquet porttitor venenatis. Donec a dui et dui fringilla consectetur id nec massa.</p>\r\n<blockquote>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit.</p>\r\n<small>Samantha Akkineni</small></blockquote>\r\n<p>Despite their best efforts many schools have struggled to adapt to the current crisis, with teachers under a lot of strain to keep lessons going without systems designed to help them manage their curriculums appropriately. As time has progressed, many people (particularly parents) have asked why technology, that is increasingly used in our private lives (particularly younger generations), is not being utilised to its full potential in education. Experts in the industry are already predicting the impact of coronavirus will compel many institutions to rethink their learning strategies.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>DUIS AUTE IRURE DOLOR IN REPREHENDERIT</h3>\r\n<p>This webinar will present Open eLMS Live - a system designed to help teachers deliver a timetable of classroom learning remotely using existing teleconferencing systems and online learning resources. We are confident that you will see the benefits of running this remote learning platform now and also when your school reopens. It will also enable you to create a plan of action should a shutdown be necessary at any time in the future.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 10:13:16', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '2', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vacation-with-a-mission-6.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/vacation-with-a-mission-6-h.jpg\"}}', '0', '0'),
('7', '0', '181', 'Graduation day', 'graduation-day', '<p>As a librarian, there are certain moments that stick with me. When one of my students unexpectedly gave me a mutinous look, I knew it was the start of one of them.</p>\r\n', '\r\n<h2>Jessica Alba has seen her share of classroom tumult.</h2>\r\n<p>What does Robertson-Eletto offer instead? “It might sound soft and fluffy, but when you approach students with a focus on respect and dignity, there just are no discipline issues. They will do whatever you ask them to do,” she says.</p>\r\n<p>She’s not alone. There is a growing consensus among experts in the field that teachers who take the time to build stronger relationships with their students can markedly reduce the classroom disruptions that too often mar the school day. This approach can also make teachers more effective in dealing with any acting-out behaviors that do occur.</p>\r\n<blockquote>\r\n<p><em>Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit...</em></p>\r\n<small>Jessica Alba</small></blockquote>\r\n<p>Jessica Alba has seen her share of classroom tumult.</p>\r\n<p>“I’ve taught in a school where I had to pat a girl down every day because she was stealing things and bringing things to school that she wasn’t supposed to have. I’ve had a first-grader who had very violent tendencies and almost broke my arm. He tore apart my classroom, attacked children,” says DiBiasi, who is presently on maternity leave from her job teaching 5th grade special education at a Bronx, NY public school.</p>\r\n<p>“No child is just lazy or just naughty. There’s always a reason that it is happening. A lot of negative behavior is attention-seeking, kids looking to get a rise out of other children or who can’t get enough attention at home,” she says. “When you can identify the ‘why’ behind the behavior, when you show compassion and try to get to the bottom of it, then you can make meaningful change.”</p>\r\n<h2>This is 2020. Why are we still talking about discipline?</h2>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<p>One student would constantly sit with arms crossed, silent. “To a teacher it looks like defiance,” she says. “But I took time to speak to her mother, I got her back-story and came to find out that this was her first year in a special education setting and she was worried about the stigma that was created around that. She shut down because of those feelings, and I was then able to find ways to help her feel smarter, to be more tender in my delivery to her and she started to open up.”</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 07:58:58', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '2', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/graduation-day-7.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/graduation-day-7-h.jpg\"}}', '0', '0'),
('8', '0', '182', 'School sports', 'school-sports', '<p>With the commitment to contribute to the development of Education of Vietnam by giving students the opportunity to study UK undergraduate and postgraduate programs in an international learning environment in Vietnam, in the school year of 2020 – 2021, British University Vietnam has officially launched Lion’s Heart Scholarship specifically for disadvantaged students who always make great effort to overcome the difficulties in life.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>The Lion’s Heart Scholarship programme is a full scholarship that covers the tuition fees for Pathway programmes, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the programme is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British owned university in Vietnam to disadvantaged students. The candidates are selected based on their disadvantaged background including their need for financial support, physical or mental disability along with a combination of previous academic performance, relevant experience of community work and the potential to become leaders in the public sector, business, and academia. For the school year 2020 – 2021, BUV will grant 1 Lion’s Heart Scholarship a value of up to over VND 1 billion.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>UT ENIM AD MINIM VENIAM</h3>\r\n<p>The scholarship programme applies to the following courses, which are entirely taught at BUV and awarded by Staffordshire University: BSc (Hons) International Business Management, BSc (Hons) Computer Science: Cyber Security/Cloud, Networks and Security, BA (Hons) Marketing Management, BA (Hons) Accounting and Finance, BA (Hons) Finance and Economics, BA (Hons) Tourism Management, BA (Hons) Events Management, BA (Hons) Contemporary Creative Practice: Graphic Design/ Illustration/ Photography, BA (Hons) Computer Games Design and Programming, BA (Hons) International Hospitality Management.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 08:08:14', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '2', '2', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/school-sports-8.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/school-sports-8-h.jpg\"}}', '0', '0'),
('9', '0', '183', 'Extracurricular Activities', 'extracurricular-activities', '<p>With the commitment to contribute to the development of Education of Vietnam by giving students the opportunity to study UK undergraduate and postgraduate programs in an international learning environment in Vietnam, in the school year of 2020 – 2021, British University Vietnam has officially launched Lion’s Heart Scholarship specifically for disadvantaged students who always make great effort to overcome the difficulties in life.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>The Lion’s Heart Scholarship programme is a full scholarship that covers the tuition fees for Pathway programmes, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the programme is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British owned university in Vietnam to disadvantaged students. The candidates are selected based on their disadvantaged background including their need for financial support, physical or mental disability along with a combination of previous academic performance, relevant experience of community work and the potential to become leaders in the public sector, business, and academia. For the school year 2020 – 2021, BUV will grant 1 Lion’s Heart Scholarship a value of up to over VND 1 billion.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>UT ENIM AD MINIM VENIAM</h3>\r\n<p>The scholarship programme applies to the following courses, which are entirely taught at BUV and awarded by Staffordshire University: BSc (Hons) International Business Management, BSc (Hons) Computer Science: Cyber Security/Cloud, Networks and Security, BA (Hons) Marketing Management, BA (Hons) Accounting and Finance, BA (Hons) Finance and Economics, BA (Hons) Tourism Management, BA (Hons) Events Management, BA (Hons) Contemporary Creative Practice: Graphic Design/ Illustration/ Photography, BA (Hons) Computer Games Design and Programming, BA (Hons) International Hospitality Management.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 08:18:24', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '3', '1', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/extracurricular-activities-9.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/extracurricular-activities-9-h.jpg\"}}', '0', '0'),
('10', '0', '184', 'Adventure Leadership', 'adventure-leadership', '<p>With the commitment to contribute to the development of Education of Vietnam by giving students the opportunity to study UK undergraduate and postgraduate programs in an international learning environment in Vietnam, in the school year of 2020 – 2021, British University Vietnam has officially launched Lion’s Heart Scholarship specifically for disadvantaged students who always make great effort to overcome the difficulties in life.</p>\r\n', '\r\n<h3>LOREM IPSUM DOLOR SIT AMET</h3>\r\n<p>The Lion’s Heart Scholarship programme is a full scholarship that covers the tuition fees for Pathway programmes, an undergraduate course at the British University Vietnam, English Preparation course, traveling cost for attending the scholarship interview round for students who are not in Hanoi and Hung Yen (if needed) and living costs for the scholar.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>A key feature of the programme is to contribute to the Education of Vietnam’s development through providing the world-class higher education opportunities offered at the first British owned university in Vietnam to disadvantaged students. The candidates are selected based on their disadvantaged background including their need for financial support, physical or mental disability along with a combination of previous academic performance, relevant experience of community work and the potential to become leaders in the public sector, business, and academia. For the school year 2020 – 2021, BUV will grant 1 Lion’s Heart Scholarship a value of up to over VND 1 billion.</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet.</li>\r\n<li>At vero eos et <a href=\"https://www.templaza.com/\">accusamus et iusto</a> odio.</li>\r\n<li>Excepteur <em>sint occaecat</em> cupidatat non proident.</li>\r\n</ul>\r\n<h3>UT ENIM AD MINIM VENIAM</h3>\r\n<p>The scholarship programme applies to the following courses, which are entirely taught at BUV and awarded by Staffordshire University: BSc (Hons) International Business Management, BSc (Hons) Computer Science: Cyber Security/Cloud, Networks and Security, BA (Hons) Marketing Management, BA (Hons) Accounting and Finance, BA (Hons) Finance and Economics, BA (Hons) Tourism Management, BA (Hons) Events Management, BA (Hons) Contemporary Creative Practice: Graphic Design/ Illustration/ Photography, BA (Hons) Computer Games Design and Programming, BA (Hons) International Hospitality Management.</p>\r\n<blockquote>\r\n<p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<small>- JEAN-LUC PICARD</small></blockquote>\r\n<p>Candidates will be evaluated and selected for the round based on their financial situation, academic results, community volunteer participation, major choice, leadership potential, and ability to contribute to the development of BUV. Additionally, students need to supplement a certificate or a record confirming candidates’ circumstances or health status issued by the authorities.</p>', '1', '0', '2020-12-07 03:11:43', '777', '', '2020-12-07 10:04:57', '777', '0', '0000-00-00 00:00:00', '2020-12-07 03:11:43', '0000-00-00 00:00:00', '{}', '{}', '{\"project_link\":\"\",\"project_link_title\":\"\",\"show_cat_title\":\"\",\"cat_link_titles\":\"\",\"show_cat_intro\":\"\",\"show_cat_category\":\"\",\"cat_link_category\":\"\",\"show_cat_parent_category\":\"\",\"cat_link_parent_category\":\"\",\"show_cat_author\":\"\",\"cat_link_author\":\"\",\"show_cat_create_date\":\"\",\"show_cat_modify_date\":\"\",\"show_cat_publish_date\":\"\",\"show_cat_icons\":\"\",\"show_cat_print_icon\":\"\",\"show_cat_email_icon\":\"\",\"show_cat_hits\":\"\",\"show_cat_tags\":\"\",\"show_title\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_noauth\":\"\",\"show_about_author\":\"\",\"show_gender_user\":\"\",\"show_email_user\":\"\",\"show_url_user\":\"\",\"show_description_user\":\"\",\"show_related_article\":\"\",\"related_article_by\":\"\",\"related_limit\":\"\",\"show_related_heading\":\"\",\"related_heading\":\"\",\"show_related_title\":\"\",\"show_related_featured\":\"\",\"related_orderby\":\"\",\"show_cat_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\"}', '4', '0', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\",\"page_title\":\"\"}', '0', '*', '', 'image', '{\"image\":{\"caption\":\"\",\"url\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/adventure-leadership-10.jpg\",\"url_detail\":\"media\\/tz_portfolio_plus\\/article\\/cache\\/adventure-leadership-10-h.jpg\"}}', '0', '0');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) NOT NULL DEFAULT 0,
  `images` text DEFAULT NULL,
  `template_id` int(10) unsigned NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__tz_portfolio_plus_categories`  VALUES 
('1', '0', '', '0', '0', '0', '0', '5', '0', '', 'system', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{}', '', '', '', '777', '2011-01-01 00:00:01', '0', '0000-00-00 00:00:00', '0', '*', '1'),
('2', '0', '', '0', '158', '1', '1', '2', '1', 'uncategorised', 'com_tz_portfolio_plus', 'Uncategorised', 'uncategorised', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"inheritFrom\":\"0\",\"category_layout\":\"\",\"image\":\"\",\"show_cat_title\":\"1\",\"cat_link_titles\":\"1\",\"show_cat_intro\":\"1\",\"show_cat_category\":\"0\",\"cat_link_category\":\"1\",\"show_cat_parent_category\":\"0\",\"cat_link_parent_category\":\"1\",\"show_cat_author\":\"0\",\"cat_link_author\":\"1\",\"show_cat_create_date\":\"0\",\"show_cat_modify_date\":\"0\",\"show_cat_publish_date\":\"0\",\"show_cat_readmore\":\"1\",\"show_cat_hits\":\"0\",\"show_cat_tags\":\"0\",\"show_cat_icons\":\"1\",\"show_cat_print_icon\":\"0\",\"show_cat_email_icon\":\"0\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_noauth\":\"0\",\"link_category\":\"1\",\"link_parent_category\":\"1\",\"show_gender_user\":\"1\",\"show_email_user\":\"1\",\"show_url_user\":\"1\",\"show_description_user\":\"1\",\"show_related_article\":\"1\",\"related_limit\":\"5\",\"show_related_heading\":\"1\",\"related_heading\":\"\",\"show_related_title\":\"1\",\"show_related_featured\":\"1\",\"related_orderby\":\"rdate\",\"mt_show_cat_image_hover\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_size\":\"\",\"mt_show_image_hover\":\"\",\"mt_image_use_cloud\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\",\"show_cat_vote\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '777', '2015-12-12 14:42:28', '0', '2015-12-12 14:42:28', '0', '*', '1'),
('3', '0', '', '0', '173', '1', '3', '4', '1', 'gallery', 'com_tz_portfolio_plus', 'Gallery', 'gallery', '', '', '1', '0', '0000-00-00 00:00:00', '1', '{\"inheritFrom\":\"0\",\"show_cat_title\":\"0\",\"cat_link_titles\":\"1\",\"show_cat_intro\":\"0\",\"show_cat_category\":\"0\",\"cat_link_category\":\"1\",\"show_cat_parent_category\":\"0\",\"cat_link_parent_category\":\"1\",\"show_cat_author\":\"0\",\"cat_link_author\":\"1\",\"show_cat_create_date\":\"0\",\"show_cat_modify_date\":\"0\",\"show_cat_publish_date\":\"0\",\"show_cat_readmore\":\"0\",\"show_cat_hits\":\"0\",\"show_cat_tags\":\"0\",\"show_cat_icons\":\"1\",\"show_cat_print_icon\":\"0\",\"show_cat_email_icon\":\"0\",\"show_title\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"1\",\"link_parent_category\":\"1\",\"show_author\":\"1\",\"link_author\":\"1\",\"show_create_date\":\"1\",\"show_modify_date\":\"1\",\"show_publish_date\":\"1\",\"show_hits\":\"1\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_noauth\":\"0\",\"show_about_author\":\"1\",\"show_gender_user\":\"1\",\"show_email_user\":\"1\",\"show_url_user\":\"1\",\"show_description_user\":\"1\",\"show_related_article\":\"1\",\"related_article_by\":\"tag\",\"related_limit\":\"5\",\"show_related_heading\":\"1\",\"related_heading\":\"\",\"show_related_title\":\"1\",\"show_related_featured\":\"1\",\"related_orderby\":\"rdate\",\"show_cat_vote\":\"\",\"show_vote\":\"\",\"mt_image_show_image_category\":\"\",\"mt_cat_image_size\":\"\",\"mt_image_show_image_tag\":\"\",\"mt_image_show_image_user\":\"\",\"mt_image_show_image_date\":\"\",\"mt_image_show_image_article\":\"\",\"mt_image_size\":\"\",\"mt_image_related_show_image\":\"\",\"mt_image_related_size\":\"\",\"mt_image_watermark_admin_options\":{\"mt_image_watermark\":\"\",\"mt_image_wtm_original_image\":\"\",\"mt_image_watermark_img_detail\":\"\",\"mt_image_watermark_stype\":\"\"}}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '777', '2020-12-07 03:01:24', '777', '2020-12-07 03:19:43', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_addon_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `addon_id` int(10) unsigned NOT NULL DEFAULT 0,
  `data_id` int(11) NOT NULL DEFAULT 0,
  `meta_id` int(11) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) NOT NULL DEFAULT '',
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__tz_portfolio_plus_addon_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extension_id` int(11) NOT NULL,
  `element` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint(4) NOT NULL DEFAULT 0,
  `parent` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('9', 'tz_educab', '0', '1', 'tz_educab - Default', '{\"astroid\":9}', '0', ''),
('10', 'tz_educab', '0', '0', 'tz_educab - Home Page', '{\"astroid\":10}', '0', ''),
('16', 'tz_educab', '0', '0', 'tz_educab - Default - Page Builder', '{\"astroid\":16}', '0', ''),
('17', 'tz_educab', '0', '0', 'tz_educab - Default - No Sidebar', '{\"astroid\":17}', '0', ''),
('18', 'atum', '1', '1', 'Atum - Default', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}', '1', ''),
('19', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '{}', '1', '');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_overrides`  VALUES 
('2', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy9jb25maWcvZGVmYXVsdC5waHA=', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-05-17 09:21:29'),
('3', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy9jb25maWcvZGVmYXVsdF9tZXRhZGF0YS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-05-17 09:21:29'),
('4', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy9jb25maWcvZGVmYXVsdF9zZW8ucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-05-17 09:21:29'),
('5', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy9jb25maWcvZGVmYXVsdF9zaXRlLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-05-17 09:21:29'),
('6', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19pdGVtLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('7', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZy5waHA=', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('8', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvZm9ybS9lZGl0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-05-17 09:21:29'),
('9', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9pdGVtLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('10', 'tz_educab', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9naW4ucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('11', 'tz_educab', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9nb3V0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('12', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9mdWxsX2ltYWdlLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('13', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pY29ucy9lZGl0X2xvY2sucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('14', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbnRyb19pbWFnZS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('15', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvcGFnaW5hdGlvbi9saW5rLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('16', 'tz_educab', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF91cmwucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('17', 'tz_educab', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9jb21wb25lbnQucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('18', 'tz_educab', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9oZWFkaW5nLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('19', 'tz_educab', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9zZXBhcmF0b3IucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2022-08-30 09:25:49'),
('20', 'tz_educab', 'L2h0bWwvbW9kX2JyZWFkY3J1bWJzL2RlZmF1bHQucGhw', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('21', 'tz_educab', 'L2h0bWwvbW9kX2xvZ2luL2RlZmF1bHRfbG9nb3V0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-05-17 09:21:29', '2023-08-23 02:35:04'),
('22', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L21vZHVsZXMvZGVmYXVsdC5waHA=', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('23', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L21vZHVsZXMvZGVmYXVsdF9vcHRpb25zLnBocA==', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('24', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L21vZHVsZXMvZGVmYXVsdF9wb3NpdGlvbnMucGhw', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('25', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L2NvbmZpZy9kZWZhdWx0LnBocA==', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('26', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L2NvbmZpZy9kZWZhdWx0X21ldGFkYXRhLnBocA==', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('27', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L2NvbmZpZy9kZWZhdWx0X3Nlby5waHA=', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('28', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L2NvbmZpZy9kZWZhdWx0X3NpdGUucGhw', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('29', 'tz_educab', 'L2h0bWwvY29tX2NvbmZpZy0yMDIyLTA1LTE3L3RlbXBsYXRlcy9kZWZhdWx0LnBocA==', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('30', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvZm9ybS0yMDIyLTA1LTE3L2VkaXQucGhw', '10004', '0', 'Extension Update', '0', '2022-05-17 09:23:18', NULL),
('31', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:15:17', '2023-08-23 02:35:04'),
('32', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3BhcmVudF9jYXRlZ29yeS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:15:17', '2022-08-30 09:25:49'),
('33', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19saW5rcy5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('34', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0X2xpbmtzLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('35', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdC5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('36', 'tz_educab', 'L2h0bWwvY29tX2NvbnRlbnQvZmVhdHVyZWQvZGVmYXVsdF9saW5rcy5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('37', 'tz_educab', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHQucGhw', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('38', 'tz_educab', 'L2h0bWwvY29tX3VzZXJzL3JlZ2lzdHJhdGlvbi9jb21wbGV0ZS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('39', 'tz_educab', 'L2h0bWwvY29tX3VzZXJzL3JlZ2lzdHJhdGlvbi9kZWZhdWx0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('40', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC90YWdzLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('41', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pY29ucy5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('42', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pY29ucy9jcmVhdGUucGhw', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('43', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pY29ucy9lZGl0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('44', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL21vZGlmeV9kYXRlLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('45', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('46', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NhdGVnb3J5LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('47', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2NyZWF0ZV9kYXRlLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('48', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2hpdHMucGhw', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('49', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL3B1Ymxpc2hfZGF0ZS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('50', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrLnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('51', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9yZWFkbW9yZS5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('52', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvc3lzdGVtL21lc3NhZ2UucGhw', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('53', 'tz_educab', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdC5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('54', 'tz_educab', 'L2h0bWwvbW9kX2FydGljbGVzX2NhdGVnb3JpZXMvZGVmYXVsdC5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('55', 'tz_educab', 'L2h0bWwvbW9kX2FydGljbGVzX2NhdGVnb3JpZXMvZGVmYXVsdF9pdGVtcy5waHA=', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('56', 'tz_educab', 'L2h0bWwvbW9kX2FydGljbGVzX2xhdGVzdC9kZWZhdWx0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('57', 'tz_educab', 'L2h0bWwvbW9kX2xvZ2luL2RlZmF1bHQucGhw', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2023-08-23 02:35:04'),
('58', 'tz_educab', 'L2h0bWwvbW9kX3RhZ3NfcG9wdWxhci9kZWZhdWx0LnBocA==', '10004', '0', 'Joomla Update', '0', '2022-08-30 09:25:49', '2022-08-30 09:25:49'),
('59', 'tz_educab', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdG9ycy9idXR0b25zL2J1dHRvbi5waHA=', '10004', '0', 'Joomla Update', '0', '2023-08-23 02:35:04', '2023-08-23 02:35:04');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '1', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '777', '2020-08-21 07:54:09', '', '777', '2020-08-21 07:54:09', '', '', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `section` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('1', 'Subscribe', '{\"id\":1606210046443,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1606210046442,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"80px 9vw 80px 9vw\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background\":\"#ffc600\"},\"addons\":[{\"id\":1606210046446,\"name\":\"optin_form\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Subscribe Our Newsletter To Get More Update\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"platform\":\"acymailing\",\"hide_name\":0,\"acymailing_listids\":[\"1\"],\"mailchimp_api\":\"\",\"mailchimp_listid\":\"\",\"mailchimp_action\":\"subscribed\",\"sendgrid_api\":\"\",\"sendinblue_api\":\"\",\"sendinblue_listid\":\"\",\"madmimi_user\":\"\",\"madmimi_api\":\"\",\"madmimi_listname\":\"\",\"recaptcha\":0,\"show_checkbox\":1,\"checkbox_title\":\"I agree with the <a href=\\\"#\\\">Terms of Use</a> and <a href=\\\"#\\\">Privacy Policy</a> and I declare that I have read the information that is required in accordance with <a href=\\\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.</a>\",\"grid\":\"\",\"optin_type\":\"normal\",\"optin_timein\":2000,\"optin_timeout\":10000,\"optin_width\":\"600\",\"alignment\":\"sppb-text-center\",\"form_inline\":0,\"submit_btn_inside\":0,\"custom_input\":0,\"custom_input_bgcolor\":\"rgba(239, 240, 244, 0.94)\",\"custom_input_color\":\"#999\",\"custom_input_borderless\":1,\"custom_input_border_side\":\"\",\"custom_input_border_style\":\"\",\"custom_input_padding\":\"22px 15px 22px 15px\",\"media_type\":\"\",\"image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"\",\"icon_name\":\"\",\"icon_size\":82,\"media_position\":\"\",\"content\":\"\",\"button_text\":\"SUBSCRIBE\",\"use_custom_button\":1,\"fontsize\":16,\"button_fontstyle\":\"\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"flat\",\"button_status\":\"hover\",\"button_background_color\":\"#5598ff\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#fff\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_font_family\":\"Montserrat\",\"title_font_style\":{\"weight\":800},\"title_text_color\":\"#00256e\",\"global_text_color\":\"rgb(72, 93, 136)\",\"global_link_color\":\"#00256e\",\"global_link_hover_color\":\"#1d3f83\",\"button_padding\":{\"md\":\"15px 25px 15px 25px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_shape\":\"square\"}}]}]}', '2020-12-04 09:19:23', '777');/**ABDB**/
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `code` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `catid` int(10) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `checked_out` int(10) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT 0,
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('1', '129', 'Home Page', '[{\"id\":1605085412219,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"12\",\"columns\":[{\"id\":1605085412218,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605085412222,\"name\":\"carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"autoplay\":1,\"interval\":5,\"speed\":600,\"controllers\":1,\"arrows\":1,\"alignment\":\"sppb-text-center\",\"class\":\"\",\"sp_carousel_item\":[{\"title\":\"Best University  for Education\",\"title_fontsize\":{\"md\":\"90\",\"sm\":36,\"xs\":16},\"title_lineheight\":{\"md\":\"100\",\"sm\":46,\"xs\":20},\"title_color\":\"#fff\",\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content\":\"Our university also gives you an opportunity to benefit from spending your free time by playing &amp; it\'s world best higher education\",\"content_fontsize\":{\"md\":\"18\",\"sm\":14,\"xs\":12},\"content_lineheight\":{\"md\":24,\"sm\":22,\"xs\":16},\"content_color\":\"#fff\",\"content_padding\":{\"md\":\"20px 0px 80px 0px\",\"sm\":\"15px 0px 20px 0px\",\"xs\":\"10px 0px 10px 0px\"},\"content_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"bg\":\"images/alexis-brown--xv7k95vofa-unsplash.jpg\",\"button_text\":\"LEARN MORE\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"\",\"button_status\":\"normal\",\"button_background_color\":\"#ffc600\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#0b0b0b\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"button_shape\":\"square\",\"button_size\":\"xlg\"},{\"title\":\"Where Art and Technology Collide\",\"title_fontsize\":{\"md\":\"90\",\"sm\":36,\"xs\":16},\"title_lineheight\":{\"md\":\"100\",\"sm\":46,\"xs\":20},\"title_color\":\"#fff\",\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"content\":\"You might remember the Dell computer commercials in which a youth reports this exciting news to his friends.\",\"content_fontsize\":{\"md\":\"18\",\"sm\":14,\"xs\":12},\"content_lineheight\":{\"md\":24,\"sm\":22,\"xs\":16},\"content_color\":\"#fff\",\"content_padding\":{\"md\":\"20px 0px 80px 0px\",\"sm\":\"15px 0px 20px 0px\",\"xs\":\"10px 0px 10px 0px\"},\"content_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"bg\":\"images/lucas-law-pitoug-_vo0-unsplash.jpg\",\"button_text\":\"VIEW MORE\",\"button_letterspace\":\"0\",\"button_type\":\"custom\",\"button_appearance\":\"flat\",\"button_status\":\"normal\",\"button_background_color\":\"#ffc600\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color\":\"#171717\",\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"button_color_hover\":\"#fff\",\"button_size\":\"xlg\",\"button_shape\":\"square\"}],\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605087813463,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"-129px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1605087813460,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605087813466,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-user\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Quality Teachers</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Quality Teachers</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#5599ff\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#619cf5\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605087813461,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605166612429,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-file-signature\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Best Curriculum</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Best Curriculum</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#ff5f69\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#f56b73\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605087813462,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605166612461,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-globe\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Global Recognition</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Global Recognition</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#11c0b2\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#24c1b5\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605236709038,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 150px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1605236709036,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605256069816,\"name\":\"testimonialcarousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"show_quote\":1,\"icon_size\":{\"md\":\"32\",\"sm\":48,\"xs\":48},\"icon_color\":\"rgba(237, 238, 242, 0.5)\",\"interval\":\"5\",\"height\":600,\"sp_testimonialpro_item\":[{\"title\":\"David Nguyen\",\"message\":\"TEMPLAZA is my best partner. Immediate responce and help everytime i need them . Special thanks to Nhung Nguyen for his proffesionalism and help he provides. I reccomend templaza to everyone. You wont regret it !!!!\",\"avatar\":\"images/avatars/01_testimonial.jpg\",\"url\":\"https://www.templaza.com/\",\"designation\":\"C.E.O at TemPlaza\",\"image\":\"images/naassom-azevedo-Q_Sei-TqSlc-unsplash.jpg\"},{\"title\":\"Victoria Rawson\",\"message\":\"Beautiful themes and fantastic support! Always available and efficient for any problems\",\"avatar\":\"images/avatars/03_testimonial.jpg\",\"url\":\"https://www.clevercrm.co/\",\"designation\":\"C.E.O at CleverCRM\",\"image\":\"images/tz_educab/annie-spratt-4-4wpflvhay-unsplash.jpg\"},{\"title\":\"Jamie Howell\",\"message\":\"This extension is outstanding and very flexible with different styles. Even its FREE plan works as perfectly as I’ve ever expected with their add-ons and templates included. But I will stick with the Developer plan for their prompt and friendly support.\",\"avatar\":\"images/avatars/06_team.png\",\"url\":\"https://www.tzportfolio.com/\",\"designation\":\"C.E.O at TZ Portfolio\",\"image\":\"images/christine-von-raesfeld-fjptybgkksm-unsplash.jpg\"}],\"avatar_width\":{\"md\":\"48\",\"sm\":\"\",\"xs\":\"\"},\"avatar_shape\":\"sppb-avatar-circle\",\"name_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_line_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_letterspace\":\"0px\",\"designation_block\":0,\"designation_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_line_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_fontsize\":{\"md\":16,\"sm\":16,\"xs\":16},\"content_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"content_alignment\":\"center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"content_font_style\":{\"italic\":true,\"weight\":300},\"name_color\":\"\",\"message_background\":\"#00256e\",\"boxshadow_background\":\"rgba(85, 152, 255, 0.1)\"}}]},{\"id\":1605236709037,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605236709041,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>ABOUT US</span>Welcome to <br />The University\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"1px\",\"text\":\"<p><strong>Vestibulum a viverra ex, non laoreet neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce tempus vel lacus at scelerisque.</strong></p>\\n<p>Nam in viverra mauris. Integer varius ullamcorper metus auctor porta. Pellentesque velit eros, malesuada sed lorem non, rhoncus blandit leo. Suspendisse lacus risus, sagittis vel laoreet at, placerat in ex. Sed placerat est sit amet est varius, mollis vulputate lorem varius. Praesent sollicitudin sem dignissim, venenatis ligula in, sodales augue. Nulla eleifend turpis at efficitur placerat. Proin id diam nisl. Aenean varius erat sit amet dui pulvinar.</p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"0 0 0 30px\",\"sm\":\"0 0 0 0\",\"xs\":\"0 0 0 0\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#00256e\",\"title_margin_bottom\":{\"md\":\"30\",\"sm\":\"\",\"xs\":\"\"},\"font_family\":\"\",\"title_font_style\":{\"weight\":800}}}]}]},{\"id\":1605342531571,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"25 Years Experiences in Education and Teaching\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"subtitle\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1605342531567,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531576,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/university.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531588,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"30\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Year of Experiences\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531568,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531579,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/globe.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531595,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"125\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Courses\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531569,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531582,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/teacher.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531598,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"150\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Professors\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531570,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531585,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/student.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531601,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"35\",\"number_before_after_text\":\"K\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Students\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]}]},{\"id\":1605512140791,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"48\",\"sm\":\"\",\"xs\":\"\"},\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#f7f8fd\",\"subtitle\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1605512140790,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605581058944,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Latest Courses\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"48\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"\",\"title_font_style\":{\"weight\":700},\"title_text_color\":\"#00256e\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"}}},{\"id\":1605512140794,\"name\":\"articles\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"resource\":\"article\",\"post_type\":\"\",\"include_subcat\":\"1\",\"ordering\":\"latest\",\"limit\":\"3\",\"columns\":\"3\",\"show_intro\":0,\"intro_limit\":\"200\",\"link_articles\":0,\"all_articles_btn_text\":\"See all posts\",\"all_articles_btn_letterspace\":\"0\",\"all_articles_btn_type\":\"default\",\"all_articles_btn_appearance\":\"flat\",\"all_articles_btn_background_color\":\"#444444\",\"all_articles_btn_color\":\"#fff\",\"all_articles_btn_background_color_hover\":\"#222\",\"all_articles_btn_color_hover\":\"#fff\",\"class\":\"\",\"hide_thumbnail\":0,\"show_author\":1,\"show_category\":1,\"show_date\":1,\"show_readmore\":1,\"readmore_text\":\"VIEW COURSE\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"catid\":[\"9\"]}}]}]},{\"id\":1605581841092,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":1,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/vadim-sherbakov-d6eby-faoo0-unsplash.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1605581841090,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605586568788,\"name\":\"video_button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"video_url\":\"https://www.youtube.com/watch?v=5E4jE3es0ak\",\"video_fontsize\":\"28\",\"use_border\":1,\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#ffc600\",\"padding\":\"30px 28px 30px 32px\",\"background_color\":\"#ffffff\",\"border_radius\":\"100\",\"border_color\":\"rgba(253, 253, 253, 0.5)\",\"border_width\":\"3\"}}]},{\"id\":1605581841091,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/ken-theimer-poe6q48b-5k-unsplash.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"padding\":{\"md\":\"10% 11% 10% 10%\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay\":\"rgba(0, 37, 110, 0.9)\"},\"addons\":[{\"id\":1605586568791,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>WHY CHOOSE US</span>Why you like Our University\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"1px\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#ffffff\"}},{\"id\":1605586568794,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-modern\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"We Are The Best Education\",\"icon\":\"\",\"content\":[{\"id\":1605586568,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0}}]},{\"title\":\"Our Mission & Vission\",\"icon\":\"\",\"content\":[{\"id\":1605598389241,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]},{\"title\":\"Most Successful University\",\"icon\":\"\",\"content\":[{\"id\":1605598390501,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]},{\"title\":\"We Arrange Many Events\",\"icon\":\"\",\"content\":[{\"id\":1605598425647,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}}]}],\"item_bg\":\"\",\"item_margin\":\"\",\"item_padding\":\"\",\"item_title_bg_color\":\"\",\"item_title_text_color\":\"\",\"item_title_fontsize\":\"\",\"item_title_lineheight\":\"\",\"item_title_letterspace\":\"0px\",\"item_title_padding\":\"\",\"icon_position\":\"\",\"icon_text_color\":\"\",\"icon_fontsize\":\"\",\"icon_margin\":\"\",\"item_content_padding\":\"\",\"active_title_bg_color\":\"\",\"active_title_text_color\":\"\",\"active_icon_rotate\":0,\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605685084602,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"80px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\"},\"layout\":\"12,8,4\",\"columns\":[{\"id\":1605685084601,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605685084606,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>WE ARE EXPERT</span>Meet Our Advisors\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"\",\"title_font_style\":{\"weight\":900}}}]},{\"id\":1605685084603,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1605759972698,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Nam in viverra mauris. Integer varius ullamcorper metus auctor porta. Pellentesque velit eros, malesuada sed lorem non, rhoncus blandit leo.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972695,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1605685084615,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"CAREER WITH US\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"hover\",\"background_color\":\"#ffc600\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#00256e\",\"background_color_hover\":\"#ffce23\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#00256e\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"17px 31px 16px 31px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"size\":\"\",\"shape\":\"square\",\"font_style\":{\"weight\":800},\"font_family\":\"Montserrat\"}}]}]},{\"id\":1605759972711,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 80px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1605759972707,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605759972714,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/luis-villasmil-1222180-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Ahin Xian\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Mathematics\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972708,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925101,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2020/11/19/marius-ciocirlan-398931-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Phillip Doe\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Geography\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972709,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925104,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/mubariz-mehdizadeh-364026-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Jonathan Howatt\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Chemistry\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972710,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925107,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/daria-tumanova-311044-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Alisa Katherine\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Physics\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605837912786,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#5598ff\"},\"layout\":\"12\",\"columns\":[{\"id\":1605837912785,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605837912789,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"What Students Say\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#ffffff\",\"global_text_color\":\"#ececec\",\"font_family\":\"\",\"title_font_style\":{\"weight\":800}}},{\"id\":1606195211983,\"name\":\"testimonial_carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"carousel_options\":\"elements\",\"testimonial_carousel_layout\":\"testi_layout1\",\"show_quote_icon\":1,\"carousel_margin\":\"30\",\"carousel_autoplay\":0,\"carousel_speed\":1500,\"carousel_interval\":4500,\"sp_testimonial_carousel_item\":[{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-1.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-2.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-3.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-1.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-2.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-3.png\"}],\"content_alignment\":\"sppb-text-center\",\"avatar_layout\":\"avatar_layout3\",\"avatar_height\":60,\"avatar_width\":60,\"avatar_border_radius\":100,\"avatar_gap\":15,\"quote_icon_color\":\"#dbdbdb\",\"quote_icon_size\":50,\"quote_icon_gap\":20,\"rating_color\":\"#ffb527\",\"rating_size\":18,\"rating_gap\":20,\"content_style\":\"designation_style\",\"name_text_color\":\"#00256e\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"name_margin\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"designation_text_color\":\"#888d92\",\"designation_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"message_background\":\"#f8f8f8\",\"message_text_color\":\"#888d92\",\"message_fontsize\":18,\"message_lineheight\":32,\"message_letterspace\":\"0px\",\"message_margin_bottom\":40,\"message_padding\":{\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"15px 15px 15px 15px\"},\"carousel_navigation\":\"arrow_controller\",\"carousel_bullet\":1,\"bullet_style\":\"normal_bullet\",\"bullet_height\":12,\"bullet_width\":12,\"bullet_background\":\"#dbdbdb\",\"bullet_border_width\":0,\"bullet_border_color\":\"\",\"bullet_active_background\":\"#ffc600\",\"carousel_arrow\":1,\"arrow_icon\":\"long_arrow\",\"arrow_style\":\"hover_arrow\",\"arrow_height\":50,\"arrow_width\":52,\"arrow_background\":\"#ffc600\",\"arrow_color\":\"#fff\",\"arrow_font_size\":24,\"arrow_border_width\":\"\",\"arrow_border_color\":\"\",\"arrow_border_radius\":\"0\",\"arrow_hover_background\":\"#ffd12c\",\"arrow_hover_color\":\"\",\"arrow_hover_border_color\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"carousel_item_number\":{\"md\":\"3\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"content_padding\":{\"md\":\"50px 30px 50px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"content_background\":\"#ffffff\"}}]}]},{\"id\":1606125095173,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"80px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#f7f8fd\"},\"layout\":\"12\",\"columns\":[{\"id\":1606125095172,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1606125095176,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Latest News\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"\",\"global_text_color\":\"\",\"font_family\":\"\",\"title_font_style\":{\"weight\":800}}},{\"id\":1606125095181,\"name\":\"articles\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"resource\":\"article\",\"post_type\":\"\",\"include_subcat\":1,\"ordering\":\"latest\",\"limit\":\"2\",\"columns\":\"2\",\"show_intro\":1,\"intro_limit\":\"200\",\"link_articles\":0,\"all_articles_btn_text\":\"See all posts\",\"all_articles_btn_letterspace\":\"0\",\"all_articles_btn_type\":\"default\",\"all_articles_btn_appearance\":\"flat\",\"all_articles_btn_background_color\":\"#444444\",\"all_articles_btn_color\":\"#fff\",\"all_articles_btn_background_color_hover\":\"#222\",\"all_articles_btn_color_hover\":\"#fff\",\"class\":\"\",\"hide_thumbnail\":0,\"show_author\":1,\"show_category\":1,\"show_date\":1,\"show_readmore\":1,\"readmore_text\":\"Read More\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"catid\":[\"8\"]}}]}]}]', 'com_sppagebuilder', 'page', '0', '0', '1', '0', '1', '0', '0000-00-00 00:00:00', '777', '2020-12-11 03:41:26', '777', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '295', '');/**ABDB**/
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('2', '0', 'Bottom', '[{\"id\":1606206322652,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\"},\"layout\":\"4,2,2,2,2\",\"columns\":[{\"id\":1606206322648,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1606206322656,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/tz_educab/logo-white.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1606206322659,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-location-arrow\",\"icon_size\":{\"md\":\"14\"},\"icon_color\":\"#ffc600\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"1244 King Street, Behind Alis Steet,<br />Melbourne, Australia.\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 15px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}},{\"id\":1606206765437,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-phone-alt\",\"icon_size\":{\"md\":\"14\"},\"icon_color\":\"#ffc600\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"1-700-345-6789<br />1-800-345-6789\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 15px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}},{\"id\":1606206765440,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fas fa-envelope\",\"icon_size\":{\"md\":\"14\"},\"icon_color\":\"#ffc600\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"info@university.com\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]},{\"id\":1606206322649,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1606207527237,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"id\":\"95\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_family\":\"\",\"title_font_style\":{\"weight\":700}}}]},{\"id\":1606206322650,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1606292912530,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Find Courses\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"id\":\"96\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_font_family\":\"\",\"title_font_style\":{\"weight\":700}}}]},{\"id\":1606206322651,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1606293227180,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Support\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"\",\"title_font_style\":{\"weight\":700}}},{\"id\":1606294363630,\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"sp_link_list_item\":[{\"title\":\"Forums\",\"active\":0,\"class\":\"\"},{\"title\":\"FAQs\",\"active\":0,\"class\":\"\"},{\"title\":\"Terms of Use\",\"active\":0,\"class\":\"\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"link_bg_hover\":\"rgba(0, 0, 0, 0.05)\",\"link_border_radius\":3,\"link_fontsize\":\"\",\"link_lineheight\":\"\",\"link_letterspace\":\"0\",\"link_text_transform\":\"none\",\"link_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"link_color_active\":\"#22b8f0\",\"link_bg_active\":\"rgba(0, 0, 0, 0.05)\",\"link_border_radius_active\":3,\"icon_position\":\"left\",\"icon_size\":\"\",\"responsive_menu\":0,\"responsive_bar_bg\":\"rgba(0, 0, 0, .1)\",\"responsive_bar_bg_active\":\"#22b8f0\",\"responsive_bar_color\":\"#000\",\"responsive_bar_color_active\":\"#fff\",\"global_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"link_margin\":{\"md\":\"0 0 12px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]},{\"id\":1606206322653,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1606294363627,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Follow Us\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"\",\"title_font_style\":{\"weight\":700}}},{\"id\":1606293147087,\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"sp_link_list_item\":[{\"title\":\"Facebook\",\"active\":0,\"class\":\"\",\"url\":\"https://www.facebook.com/templaza\",\"icon\":\"fab fa-facebook-f\"},{\"title\":\"Twitter\",\"active\":0,\"class\":\"\",\"url\":\"https://twitter.com/templazavn\",\"icon\":\"fab fa-twitter\"},{\"title\":\"Github\",\"active\":0,\"class\":\"\",\"url\":\"https://github.com/templaza\",\"icon\":\"fab fa-github-alt\"},{\"title\":\"Dribbble\",\"active\":0,\"class\":\"\",\"url\":\"https://dribbble.com/templaza\",\"icon\":\"fab fa-dribbble\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"link_bg_hover\":\"rgba(0, 0, 0, 0.05)\",\"link_border_radius\":3,\"link_fontsize\":\"\",\"link_lineheight\":\"\",\"link_letterspace\":\"0\",\"link_text_transform\":\"none\",\"link_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"link_color_active\":\"#22b8f0\",\"link_bg_active\":\"rgba(0, 0, 0, 0.05)\",\"link_border_radius_active\":3,\"icon_position\":\"left\",\"icon_size\":\"\",\"responsive_menu\":0,\"responsive_bar_bg\":\"rgba(0, 0, 0, .1)\",\"responsive_bar_bg_active\":\"#22b8f0\",\"responsive_bar_color\":\"#000\",\"responsive_bar_color_active\":\"#fff\",\"global_class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"link_margin\":{\"md\":\"0 0 12px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]}]}]', 'mod_sppagebuilder', 'module', '91', '1', '1', '0', '1', '0', '2020-11-24 08:25:21', '777', '2020-12-11 03:44:21', '777', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '0', '');
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('3', '139', 'About Us', '[{\"id\":1605236709038,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 250px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1605236709036,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605256069816,\"name\":\"testimonialcarousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"show_quote\":1,\"icon_size\":{\"md\":\"32\",\"sm\":48,\"xs\":48},\"icon_color\":\"rgba(237, 238, 242, 0.5)\",\"interval\":\"5\",\"height\":600,\"sp_testimonialpro_item\":[{\"title\":\"David Nguyen\",\"message\":\"TEMPLAZA is my best partner. Immediate responce and help everytime i need them . Special thanks to Nhung Nguyen for his proffesionalism and help he provides. I reccomend templaza to everyone. You wont regret it !!!!\",\"avatar\":\"images/avatars/01_testimonial.jpg\",\"url\":\"https://www.templaza.com/\",\"designation\":\"C.E.O at TemPlaza\",\"image\":\"images/naassom-azevedo-Q_Sei-TqSlc-unsplash.jpg\"},{\"title\":\"Victoria Rawson\",\"message\":\"Beautiful themes and fantastic support! Always available and efficient for any problems\",\"avatar\":\"images/avatars/03_testimonial.jpg\",\"url\":\"https://www.clevercrm.co/\",\"designation\":\"C.E.O at CleverCRM\",\"image\":\"images/tz_educab/annie-spratt-4-4wpflvhay-unsplash.jpg\"},{\"title\":\"Jamie Howell\",\"message\":\"This extension is outstanding and very flexible with different styles. Even its FREE plan works as perfectly as I’ve ever expected with their add-ons and templates included. But I will stick with the Developer plan for their prompt and friendly support.\",\"avatar\":\"images/avatars/06_team.png\",\"url\":\"https://www.tzportfolio.com/\",\"designation\":\"C.E.O at TZ Portfolio\",\"image\":\"images/christine-von-raesfeld-fjptybgkksm-unsplash.jpg\"}],\"avatar_width\":{\"md\":\"48\",\"sm\":\"\",\"xs\":\"\"},\"avatar_shape\":\"sppb-avatar-circle\",\"name_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_line_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_letterspace\":\"0px\",\"designation_block\":0,\"designation_font_size\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_line_height\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_fontsize\":{\"md\":16,\"sm\":16,\"xs\":16},\"content_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"content_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"content_alignment\":\"center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"content_font_style\":{\"italic\":true,\"weight\":300},\"name_color\":\"\",\"message_background\":\"#00256e\",\"boxshadow_background\":\"rgba(85, 152, 255, 0.1)\"}}]},{\"id\":1605236709037,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605236709041,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>ABOUT US</span>Welcome to <br />The University\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"1px\",\"text\":\"<p><strong>Vestibulum a viverra ex, non laoreet neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce tempus vel lacus at scelerisque.</strong></p>\\n<p>Nam in viverra mauris. Integer varius ullamcorper metus auctor porta. Pellentesque velit eros, malesuada sed lorem non, rhoncus blandit leo. Suspendisse lacus risus, sagittis vel laoreet at, placerat in ex. Sed placerat est sit amet est varius, mollis vulputate lorem varius. Praesent sollicitudin sem dignissim, venenatis ligula in, sodales augue. Nulla eleifend turpis at efficitur placerat. Proin id diam nisl. Aenean varius erat sit amet dui pulvinar.</p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"0 0 0 30px\",\"sm\":\"0 0 0 0\",\"xs\":\"0 0 0 0\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#00256e\",\"title_margin_bottom\":{\"md\":\"30\",\"sm\":\"\",\"xs\":\"\"},\"font_family\":\"\",\"title_font_style\":{\"weight\":800}}}]}]},{\"id\":1605087813463,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"120px 0px 90px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/lucas-law-pitoug-_vo0-unsplash.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"background_color\":\"#00256e\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1605087813460,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605087813466,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-user\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Quality Teachers</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Quality Teachers</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#5599ff\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#619cf5\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605087813461,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605166612429,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-file-signature\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Best Curriculum</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Best Curriculum</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#ff5f69\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#f56b73\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605087813462,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605166612461,\"name\":\"flip_box\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"flip_bhave\":\"hover\",\"front_text\":\"<i class=\\\"fas fa-globe\\\" style=\\\"font-size:50px;display:inline-block;color:#ffffff;margin-bottom:30px;\\\" aria-hidden=\\\"true\\\"></i><h2 style=\\\"color:#ffffff;margin-bottom:25px;\\\">Global Recognition</h2><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p>\",\"flip_text\":\"<h3 style=\\\"margin-bottom:20px;color:#ffffff;\\\">Global Recognition</h3><p>Successful businesses have many things in common, today we’ll look at the big ‘R’of recognitional advertising network may help.</p><a class=\\\"btn btn-light\\\" href=\\\"#\\\">READ MORE</a>\",\"class\":\"\",\"flip_style\":\"flat_style\",\"rotate\":\"flip_right\",\"height\":{\"md\":\"400\",\"sm\":\"\",\"xs\":\"\"},\"text_align\":\"center\",\"border_styles\":\"\",\"border_color\":\"#000\",\"front_bgcolor\":\"#11c0b2\",\"front_bgimg\":\"\",\"front_textcolor\":\"#fff\",\"back_bgcolor\":\"#24c1b5\",\"back_bgimg\":{\"src\":\"\"},\"back_textcolor\":\"#fff\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605342531571,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"25 Years Experiences in Education and Teaching\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"container_width\":{\"unit\":\"px\"},\"container_max_width\":{\"unit\":\"px\"},\"container_min_width\":{\"unit\":\"px\"},\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"subtitle\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1605342531567,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531576,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/university.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531588,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"30\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Year of Experiences\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531568,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531579,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/globe.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531595,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"125\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Courses\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531569,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531582,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/teacher.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531598,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"150\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Professors\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]},{\"id\":1605342531570,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605342531585,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/student.png\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}},{\"id\":1605342531601,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"35\",\"number_before_after_text\":\"K\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"48\"},\"line_height\":{\"md\":36},\"counter_title\":\"Students\",\"title_font_size\":{\"md\":18},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"color\":\"#5598ff\",\"title_color\":\"#00256e\",\"number_font_family\":\"Montserrat\",\"number_font_wight\":\"700\"}}]}]},{\"id\":1605685084602,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"80px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#f7f8fd\"},\"layout\":\"12,8,4\",\"columns\":[{\"id\":1605685084601,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605685084606,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"<span>WE ARE EXPERT</span>Meet Our Advisors\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"font_family\":\"\",\"title_font_style\":{\"weight\":900}}}]},{\"id\":1605685084603,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1605759972698,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Nam in viverra mauris. Integer varius ullamcorper metus auctor porta. Pellentesque velit eros, malesuada sed lorem non, rhoncus blandit leo.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972695,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{},\"addons\":[{\"id\":1605685084615,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"CAREER WITH US\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"hover\",\"background_color\":\"#ffc600\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#00256e\",\"background_color_hover\":\"#ffce23\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#00256e\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"17px 31px 16px 31px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"size\":\"\",\"shape\":\"square\",\"font_style\":{\"weight\":800},\"font_family\":\"Montserrat\"}}]}]},{\"id\":1605759972711,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 80px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#f7f8fd\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1605759972707,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605759972714,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/luis-villasmil-1222180-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Ahin Xian\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Mathematics\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972708,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925101,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2020/11/19/marius-ciocirlan-398931-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Phillip Doe\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Geography\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972709,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925104,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/mubariz-mehdizadeh-364026-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Jonathan Howatt\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Chemistry\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]},{\"id\":1605759972710,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605774925107,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/daria-tumanova-311044-unsplash.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"layout1\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"20px 20px 20px 20px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Alisa Katherine\",\"name_fontsize\":\"\",\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Professor of Physics\",\"designation_fontsize\":\"\",\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/templaza\",\"twitter\":\"http://twitter.com/templazavn\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}]}}]}]},{\"id\":1605837912786,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"100px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#5598ff\"},\"layout\":\"12\",\"columns\":[{\"id\":1605837912785,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1605837912789,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"What Students Say\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"52\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"What do you think is better to receive after each lesson: a lovely looking badge or important skills you can immediately put into practice.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title_text_color\":\"#ffffff\",\"global_text_color\":\"#ececec\",\"font_family\":\"\",\"title_font_style\":{\"weight\":800}}},{\"id\":1606195211983,\"name\":\"testimonial_carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"carousel_options\":\"elements\",\"testimonial_carousel_layout\":\"testi_layout1\",\"show_quote_icon\":1,\"carousel_margin\":\"30\",\"carousel_autoplay\":0,\"carousel_speed\":1500,\"carousel_interval\":4500,\"sp_testimonial_carousel_item\":[{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-1.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-2.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-3.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-1.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-2.png\"},{\"client_name\":\"Edward Morinho\",\"client_desgination\":\"Full Stack Devloper\",\"client_message\":\"Testimonial carousel is modern and stylish addon for SP Page Builder . Instantly raise your website appearance with this stylish new addon.\",\"show_rating\":1,\"client_rating\":4.5,\"testimonial_carousel_img\":\"https://sppagebuilder.com/addons/testimonial_carousel/testimonial-person-3.png\"}],\"content_alignment\":\"sppb-text-center\",\"avatar_layout\":\"avatar_layout3\",\"avatar_height\":60,\"avatar_width\":60,\"avatar_border_radius\":100,\"avatar_gap\":15,\"quote_icon_color\":\"#dbdbdb\",\"quote_icon_size\":50,\"quote_icon_gap\":20,\"rating_color\":\"#ffb527\",\"rating_size\":18,\"rating_gap\":20,\"content_style\":\"designation_style\",\"name_text_color\":\"#00256e\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"name_margin\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"designation_text_color\":\"#888d92\",\"designation_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"message_background\":\"#f8f8f8\",\"message_text_color\":\"#888d92\",\"message_fontsize\":18,\"message_lineheight\":32,\"message_letterspace\":\"0px\",\"message_margin_bottom\":40,\"message_padding\":{\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"15px 15px 15px 15px\"},\"carousel_navigation\":\"arrow_controller\",\"carousel_bullet\":1,\"bullet_style\":\"normal_bullet\",\"bullet_height\":12,\"bullet_width\":12,\"bullet_background\":\"#dbdbdb\",\"bullet_border_width\":0,\"bullet_border_color\":\"\",\"bullet_active_background\":\"#ffc600\",\"carousel_arrow\":1,\"arrow_icon\":\"long_arrow\",\"arrow_style\":\"hover_arrow\",\"arrow_height\":50,\"arrow_width\":52,\"arrow_background\":\"#ffc600\",\"arrow_color\":\"#fff\",\"arrow_font_size\":24,\"arrow_border_width\":\"\",\"arrow_border_color\":\"\",\"arrow_border_radius\":\"0\",\"arrow_hover_background\":\"#ffd12c\",\"arrow_hover_color\":\"\",\"arrow_hover_border_color\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"carousel_item_number\":{\"md\":\"3\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"content_padding\":{\"md\":\"50px 30px 50px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"content_background\":\"#ffffff\"}}]}]}]', 'com_sppagebuilder', 'page', '0', '0', '1', '0', '1', '0', '2020-12-04 07:56:46', '777', '2020-12-11 03:43:35', '777', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '32', '');/**ABDB**/
